#ifndef FRAMEAPI__MOUNT_MGR_HH
#define FRAMEAPI__MOUNT_MGR_HH

#include <sys/types.h>

#include <sstream>
#include <list>
#include <string>

#include "general/unordered_map.hh"
#include "general/ReadWriteLock.hh"

namespace FrameAPI
{
  class MountMgr
  {
  public:
    struct MountPoint {
      std::string	s_fsname;
      std::string	s_dir;
      std::string	s_type;
      std::string	s_options;
      dev_t		s_device;

      MountPoint( );
      MountPoint( const std::string&	FSName,
		  const std::string&	Dir,
		  const std::string&	Type,
		  const std::string&	Options,
		  dev_t			Device );
    };
    
    typedef General::unordered_map< dev_t, MountPoint >	mnt_info_type;
    typedef std::list< std::string >			active_fstypes_type;
    typedef General::ReadWriteLock::lock_type		lock_type;

    MountMgr( );
    ~MountMgr( );

    void IsKnownFSType( const std::string& FSType );
    lock_type& GetLock( );
    const MountPoint Lookup( const std::string& FSType );
    const MountPoint Lookup( dev_t Device );	

  private:

    lock_type		m_update_lock;
    mnt_info_type	m_mnt_info;
    active_fstypes_type	m_active_fstypes;
    time_t		m_last_mtime;
    std::ostringstream	m_active_fstypes_msg;

    void sync( );
  };
} // namespace FrameAPI
#endif /* FRAMEAPI__MOUNT_MGR_HH */
