#ifndef DISKCACHE_API__SERVER_INTERFACE_HH
#define DISKCACHE_API__SERVER_INTERFACE_HH

#include "diskcacheAPI/MetaCommands.hh"

namespace diskCache
{
  //=====================================================================
  /// \brief Simple interface to a standalone diskcache server
  ///
  /// This class provides a simple interface to the diskcache server.
  //=====================================================================
  class ServerInterface
    : public MetaCommand::ClientServerInterface::ServerInfo
  {
  public:
    typedef MetaCommand::ClientServerInterface
            ::ServerInfo::port_type	port_type;
    typedef INT_4U	time_type;
    typedef std::vector< std::string > filenames_rds_results_type;

    static std::string DEFAULT_EXTENSION;

    //-------------------------------------------------------------------
    /// \brief Qury for a set of files that is appropriate for RDS generation
    ///
    /// \param[out] Results
    ///     Container of file names that match the query
    /// \param[in] IFO
    ///     Interferometer
    /// \param[in] Desc
    ///     Descriptive field
    /// \param[in] StartTime
    ///     Start time of request in GPS seconds.
    /// \param[in] EndTime
    ///     End time of request in GPS seconds.
    /// \param[in] Extension
    ///     The extension, including the period, of the type of file.
    ///
    /// \todo Need to return any remaining gap information
    //-------------------------------------------------------------------
    void FilenamesRDS( filenames_rds_results_type& Results,
		       const std::string& IFO,
		       const std::string& Desc,
		       time_type StartTime,
		       time_type EndTime,
		       const std::string& Extension
		         = DEFAULT_EXTENSION );
    //-------------------------------------------------------------------
    /// \brief Configure the host and port fo the diskcache server
    //-------------------------------------------------------------------
    void Server( const std::string& Host, port_type Port );

  };

  //---------------------------------------------------------------------
  //---------------------------------------------------------------------
  inline void ServerInterface::
  Server( const std::string& HostnameValue, port_type PortValue )
  {
    Port( PortValue );
    Hostname( HostnameValue );
  }
}
#endif /* DISKCACHE_API__SERVER_INTERFACE_HH */
