// -*- mode: c++ basic-offset: 4; indent-tabs-mode: nil; -*-
#ifndef DISKCACHE_API__CACHE__INTERFACE_HH
#define DISKCACHE_API__CACHE__INTERFACE_HH

namespace diskCache
{
  namespace Cache
  {
    //-------------------------------------------------------------------
    /// \brief Interface for cached data.
    ///
    /// This interface describes a set of methods that must be
    /// defined for data to be accessable to the diskcacheAPI.
    //-------------------------------------------------------------------
    class Interface
    {
    public:
      //-----------------------------------------------------------------
      /// \brief Destructor
      //-----------------------------------------------------------------
      virtual ~Interface( );

      //-----------------------------------------------------------------
      /// \brief Allow for customization
      ///
      /// \param[in] Variable
      ///     Name of the option to modify
      /// \param[in] Value
      ///     The ascii string representation of the value for the option.
      ///
      /// \return
      ///     Upon successful setting of the option, true is returned;
      ///     false otherwise.
      //-----------------------------------------------------------------
      virtual bool
      Configure( const std::string& Variable,
                 const std::string& Value ) = 0;
    };

    inline Interface::
    ~Interface( )
    {
    }
  }
}

#endif /* DISKCACHE_API__CACHE__INTERFACE_HH */
