#ifndef DISKCACHE__CACHE__EXCLUDED_DIRECTORIES_SINGLETON_HH
#define DISKCACHE__CACHE__EXCLUDED_DIRECTORIES_SINGLETON_HH

#include "general/ReadWriteSingleton.hh"

#include "genericAPI/Logging.hh"

#include "ExcludedDirectories.hh"

namespace diskCache
{
  namespace Cache
  {
    class ExcludedDirectoriesSingleton
      : private ExcludedDirectories
    {
    public:
      typedef ExcludedDirectories::directory_container_type
      directory_container_type;
      typedef ExcludedDirectories::value_type value_type;
      typedef ExcludedDirectories::callback_type callback_type;

      static bool IsExcluded( const value_type& Directory );

      static void OnUpdate( callback_type Callback );

      static void Update( const directory_container_type& Directories );

    private:
      

    public:
      DECLARE_READ_WRITE_SINGLETON( ExcludedDirectoriesSingleton );
    };

    inline bool ExcludedDirectoriesSingleton::
    IsExcluded( const value_type& Directory )
    {
      return Instance().ExcludedDirectories::IsExcluded( Directory );
    }

    inline void ExcludedDirectoriesSingleton::
    OnUpdate( callback_type Callback )
    {
      Instance().ExcludedDirectories::OnUpdate( Callback );
    }

    inline void ExcludedDirectoriesSingleton::
    Update( const directory_container_type& Directories )
    {
      Instance().ExcludedDirectories::Update( Directories );
    }

  } /* namespace - Cache */
} /* namespace - diskCache */

#endif /* DISKCACHE__CACHE__EXCLUDED_DIRECTORIES_SINGLETON_HH */
