//!author: "Lee Samuel Finn"
//: test warning exception  class

#if HAVE_CONFIG_H
#include "general/config.h"
#endif /* HAVE_CONFIG_H */

#include <iostream>
#include <string>

#include "general/unittest.h"
#include "general/unimplemented_error.hh"

using namespace std;  //introduces namespace std

General::UnitTest Test;

int main(int ArgC, char** ArgV)
{	
    Test.Init ( ArgC , ArgV );
	if (Test.IsVerbose())
	{
		cout << "$Id: tUnimplemented.cc,v 1.3 2005/09/15 23:55:26 emaros Exp $" << endl;
	}
	
	// Throw the exception, catch it, and check its data
	
	const char* s = "unimplemented error";
	try {
	    throw General::unimplemented_error(s);
	} catch (General::unimplemented_error& x) {
		Test.Check(true, "caught unimplemented_error");  
		Test.Check(0 == strcmp(x.what(), s)) 
			<< s << " == " << x.what() << endl;
	} catch (bad_exception &x) {
		Test.Check(false,"caught bad exception");
	}
	Test.Exit(); 
}

