#ifndef GeneralUtilHH
#define GeneralUtilHH

#if ! defined(SWIGIMPORTED)
#include <assert.h>
#include <pthread.h>
#include <string>
#include <strings.h>
#endif /* ! defined(SWIGIMPORTED) */

#include "general/config.h"
#include "general/unordered_map.hh"
#include "general/reverse.hh"

std::string slower( const std::string &s );
void string2lower( std::string& s );


//-----------------------------------------------------------------------
/// \brief Objects of general use and interst.
///
/// The objects that are described in this namespace cover a broad
/// range and are to be used by many other parts of the software.
//-----------------------------------------------------------------------
namespace General
{
  int cmp_nocase( const std::string& S1, const std::string& S2 );

#if !defined(unordered_map)

  /// \brief  Hash proto
  template <class T> struct ic_hash { };

//-----------------------------------------------------------------------------
/// \brief  Case-Insensitive String Hash Specialization
///
/// A specialization of the STL hash functional to perform a case-insensitive
/// hash of a C++ string.
///
template<>
struct ic_hash< std::string >
{
  /// \brief  Overloaded call operator.
  ///  
  /// \param s A reference to the string representing the   
  ///    search key.
  ///
  /// \return size_t Index into the hash.
  /// 
  std::size_t operator()( const std::string& s ) const
  {
    std::string tmp( slower( s ));
#if defined(UNORDERED_MAP_NAMESPACE)
    General::hash< std::string > h;
    return h( tmp );
#else /* UNORDered_MAP_NAMESPACE */
    General::hash< const CHAR* > h;
    return h( tmp.c_str( ) );
#endif /* UNORDered_MAP_NAMESPACE */
  }
};

#endif	/* unordered_map */

  void
  Rethrow( const std::string& Prefix, const std::exception& Exception );
} // namespace General

//-----------------------------------------------------------------------------
/// \brief  Case-Insensitive Compare Functional
///
/// A Function Object used to perform a case-insensitive compare of two string
/// objects.
///
class CaseInsensitiveCmp
{
public:

    /// \brief  Overloaded call operator.
    ///  
    /// \param s1 A reference to the first string object.
    /// \param s2 A reference to the second string object.
    ///
    /// \return bool True if strings are equal, false otherwise.
    ///     
    bool operator()( const std::string& s1, const std::string& s2 ) const
        {
            return General::cmp_nocase( s1, s2 ) == 0;
        }
};

   
bool is_space( const char c );   
bool not_space( const char c );      
   

#endif // GeneralUtilHH
