#ifndef FormatExceptionHH
#define FormatExceptionHH

#include "general/config.h"

#include "general/ldasexception.hh"

//-----------------------------------------------------------------------------
/// \brief  Format Exception
///
/// This class is derived from LdasException.  It does not define any new
/// methods or data.  It is used simply to differentiate between error types
/// when thrown.
///
class FormatException : public LdasException
{
public:

    /* Constructors */
    FormatException( int library, int code, const std::string& msg = "",
                     const std::string& info = "", const char* file = 0,
                     size_t line = 0 ) throw();
};


//-----------------------------------------------------------------------------
/// \brief  Constructor.
///
/// Just call the LdasException constructor.
///
/// \param library
/// \param code
/// \param msg
/// \param info
/// \param file
/// \param line
///
inline FormatException::FormatException(
    int library, int code, const std::string& msg, const std::string& info,
    const char* file, size_t line )
    throw()
        : LdasException( library, code, msg, info, file, line )
{}

#endif // FormatExceptionHH
