#include "general/config.h"

#include "errorinfo.hh"
   
#include <cstring>

using std::strcmp;
using std::strcpy;
using std::strlen;

   
//-----------------------------------------------------------------------------
/// \brief  Constructor.
///
/// \param library
/// \param code
/// \param msg
/// \param info
/// \param file
/// \param line
///
ErrorInfo::ErrorInfo( int library, int code, const std::string& msg, 
   const std::string& info, const char* file, size_t line )
   : mLibrary( library ), mCode( code ), mMsg( msg ), mInfo( info ),
     mFile( 0 ), mLine( line )
{
   if( file )
   {
      const size_t file_len( strlen( file ) + 1 );
      mFile = new char[ file_len ];
   
      strcpy( mFile, file );
   }
}


//-----------------------------------------------------------------------------
/// \brief  Copy Constructor
///
/// \param e
///
ErrorInfo::ErrorInfo( const ErrorInfo& e )
   : mLibrary( e.mLibrary ), mCode( e.mCode ), mMsg( e.mMsg ),
     mInfo( e.mInfo ), mFile( 0 ), mLine( e.mLine )
{
   if( e.mFile )
   {
      const size_t file_len( strlen( e.mFile ) + 1 );
      mFile = new char[ file_len ];
   
      strcpy( mFile, e.mFile );   
   }
}
   
   
//-----------------------------------------------------------------------------
/// \brief  Destructor.
///
ErrorInfo::~ErrorInfo() 
{
   delete[] mFile;
   mFile = 0;
}


//-----------------------------------------------------------------------------
/// \brief  Equal Comparison
///
/// \param e
///
/// \return bool
///
bool ErrorInfo::operator==( const ErrorInfo& e ) const
{
    return ( mLibrary == e.mLibrary && mCode == e.mCode &&
             mLine == e.mLine && mMsg == e.mMsg &&
             mInfo == e.mInfo && strcmp( mFile, e.mFile ) == 0 );
 }
   

//-----------------------------------------------------------------------------
/// \brief  Assignment Operator
///
/// \param e
///
/// \return const ErrorInfo&
///
const ErrorInfo& ErrorInfo::operator=( const ErrorInfo& e )
{
    if ( this != &e )
    {
        mLibrary = e.mLibrary;
        mCode = e.mCode;
        mMsg = e.mMsg;
        mInfo = e.mInfo;
   
        delete[] mFile;
        mFile = 0;
     
        if( e.mFile )
        {
           const size_t file_len( strlen( e.mFile ) + 1 );
           mFile = new char[ file_len ];
    
           strcpy( mFile, e.mFile );   
        }
    
        mLine = e.mLine;
    }

    return *this;
}


