#include "general/config.h"

#ifndef GENERAL__THREAD_POOL_HH
#define GENERAL__THREAD_POOL_HH

namespace General
{
  class TaskThread;

  //---------------------------------------------------------------------
  /// \brief Maintains a pool of threads
  ///
  /// This is a singleton class that maintains a list of threads that
  /// can be reused to perform asyncronous tasks.
  //---------------------------------------------------------------------
  class ThreadPool
  {
  public:
    //-------------------------------------------------------------------
    /// \brief Acquire a thread
    ///
    /// \return
    ///     A resouce from the pool.
    //-------------------------------------------------------------------
    static TaskThread* Acquire( );

    //-------------------------------------------------------------------
    /// \brief Return a thread to the pool
    ///
    /// \param[in] Resource
    ///     Return a resouce to the pool.
    //-------------------------------------------------------------------
    static void Relinquish( TaskThread* Resource );

    //-------------------------------------------------------------------
    /// \brief Release all resources from the thread pool.
    //-------------------------------------------------------------------
    static void Reset( );

  private:
    //-------------------------------------------------------------------
    /// \brief  Hide default constructor
    ///
    /// Do not want anyone to create a seperate instance of this class.
    //-------------------------------------------------------------------
    ThreadPool( );
    //-------------------------------------------------------------------
    /// \brief  Hide copy constructor
    ///
    /// Do not want to create another instance of the class based on
    /// a priviously created instance.
    //-------------------------------------------------------------------
    ThreadPool( const ThreadPool& Source );
    //-------------------------------------------------------------------
    /// \brief  Hide assignment operator
    ///
    /// Do not want to copy one instance to another.
    //-------------------------------------------------------------------
    ThreadPool operator=( const ThreadPool& Source );
  };
}

#endif /* GENERAL__THREAD_POOL_HH */
