#ifndef LDAS__GENERAL__SO_LOADER_HH
#define LDAS__GENERAL__SO_LOADER_HH

#include <string>

#include "general/config.h"

namespace General
{
  class SOLoader
  {
  public:
    typedef void* symbol_type;
    typedef void (*function_type)(void);

    enum {
      SOLOADER_MANDITORY,
      SOLOADER_OPTIONAL
    };

    //: Constructor
    SOLoader( const std::string& Path, const std::string& LibName,
	      int Type = SOLOADER_MANDITORY );

    //: Destructor
    ~SOLoader( );

    //: Retrieve a function from the dynamically loaded library
    function_type GetFunction( const std::string& Function );

    //: Retrieve a symbol from the dynamically loaded library
    symbol_type GetSymbol( const std::string& Symbol );

  private:
    typedef void* handle_type;

    handle_type	m_handle;

    SOLoader( const General::SOLoader& Source );

    const SOLoader& operator=( const General::SOLoader& Source );
  };
}

#endif /* LDAS__GENERAL__SO_LOADER_HH */
