#ifndef DISKCACHE_READ_WRITE_SINGLETON_HH
#define DISKCACHE_READ_WRITE_SINGLETON_HH   

// System Header Files   
#include <memory>   
   
// General Header Files   
#include "general/AtExit.hh"
#include "general/ReadWriteLock.hh"
   
// Code generator to declare/instantiate methods, data members
// for singleton class with ReadWriteLock.   

//!ignore_begin:
#define EMPTY_DIRECTIVE

#define DECLARE_READ_WRITE_SINGLETON( LM_CLASS )           \
public:                                                    \
   static LM_CLASS& Instance();		                   \
private:				                   \
   LM_CLASS();                  		           \
   LM_CLASS( const LM_CLASS& );   		           \
   static General::ReadWriteLock::Sync& initialize();	   \
   static void singleton_suicide( );     		   \
   static LM_CLASS* mInstance; 			           \
   static General::ReadWriteLock::Sync& mLock;	           \
   static int m_exit_ring


   
#define DEFINE_READ_WRITE_SINGLETON_CONSTRUCTOR_BODY(LM_CLASS)			\
  General::AtExit::Append( singleton_suicide, 					\
                           #LM_CLASS, m_exit_ring )

#define DEFINE_READ_WRITE_SINGLETON_NO_CONSTRUCTOR(LM_CLASS,EXIT_RING)		\
                                                                                \
int LM_CLASS::m_exit_ring = EXIT_RING;						\
  										\
LM_CLASS* LM_CLASS::mInstance = ( LM_CLASS* )0;                         	\
General::ReadWriteLock::Sync& LM_CLASS::mLock = LM_CLASS::initialize( );	\
                                                                                \
General::ReadWriteLock::Sync& LM_CLASS::initialize()                  \
{                                                                               \
   static General::ReadWriteLock::Sync lock;                                    \
   /* General::ReadWriteLock::Initialize( lock ); */				\
   return lock;                                                                 \
}                                                                               \
                                                                                \
LM_CLASS& LM_CLASS::Instance() 		                        \
{                                                                               \
  if( mInstance == (LM_CLASS*)NULL )						\
   {		                                                                \
      General::ReadWriteLock l( mLock, General::ReadWriteLock::WRITE );         \
				                                                \
      if( mInstance == (LM_CLASS*)NULL )					\
      {							                        \
         mInstance = new LM_CLASS;                                       	\
      }							                        \
   }							                        \
   return *mInstance;	                                                        \
}                                                                               \
                                                                                \
void LM_CLASS::singleton_suicide( )                          		\
{										\
  General::ReadWriteLock l( mLock, General::ReadWriteLock::WRITE );         	\
  delete mInstance;								\
  mInstance = (LM_CLASS*)NULL; 							\
}

#define DEFINE_READ_WRITE_SINGLETON_(LM_CLASS,EXIT_RING)		\
  DEFINE_READ_WRITE_SINGLETON_NO_CONSTRUCTOR(LM_CLASS,EXIT_RING)	\
LM_CLASS::LM_CLASS() 		                                        \
{ 										\
  DEFINE_READ_WRITE_SINGLETON_CONSTRUCTOR_BODY(LM_CLASS);			\
}

#define DEFINE_READ_WRITE_SINGLETON(LM_CLASS,EXIT_RING)			\
  DEFINE_READ_WRITE_SINGLETON_(LM_CLASS,EXIT_RING)

//!ignore_end:
   
#endif   
