/* -*- mode: c++; c-basic-offset: 2; -*- */

#ifndef GENERAL__POOL_HH
#define GENERAL__POOL_HH

#include <stdexcept>
#include <list>

#include "general/mutexlock.hh"
#include "general/SharedPtr.hh"

namespace General
{
  //-------------------------------------------------------------
  /// \brief Maintain a collection system calls
  //-------------------------------------------------------------
  template< typename T >
  class Pool
  {
  public:
    typedef T	value_type;

    Pool( );

    void	Relinquish( value_type Source );

    value_type	Request( value_type (*CreateFunc)( ) );

  private:
    typedef std::list< value_type > pool_type;
    
    pool_type			m_available;
    MutexLock::lock_type	m_baton;
  };

  template< typename T >
  Pool< T >::
  Pool( )
    : m_baton( MutexLock::Initialize( ) )
  {
  }

  template< typename T >
  void Pool< T >::
  Relinquish( value_type Source )
  {
    MutexLock	l( m_baton );

    m_available.push_back( Source );
  }
  
  template< typename T >
  T Pool< T >::
  Request( value_type (*CreateFunc)( ) )
  {
    MutexLock	l( m_baton );

    value_type	retval;
    if ( m_available.empty( ) )
    {
      retval = (*CreateFunc)( );
    }
    else
    {
      retval = m_available.back( );
      m_available.pop_back( );
    }

    return retval;
  }
  
}

#endif /* GENERAL__POOL_HH */
