/* -*- mode: c++; c-basic-offset: 2; -*- */

#ifndef GENERAL__CONDITIONAL_VARIABLE_HH
#define GENERAL__CONDITIONAL_VARIABLE_HH

#include <pthread.h>

#include "general/types.hh"
#include "general/mutexlock.hh"

namespace General
{
  //---------------------------------------------------------------------
  /// \brief Thread syncronization based on condition
  //---------------------------------------------------------------------
  class ConditionalVariable
  {
  public:
    //-------------------------------------------------------------------
    /// \brief Constructor - Default
    //-------------------------------------------------------------------
    ConditionalVariable( );
    //-------------------------------------------------------------------
    /// \brief Destructor
    //-------------------------------------------------------------------
    ~ConditionalVariable( );
    //-------------------------------------------------------------------
    /// \brief Awaken some thread waiting on condition
    //-------------------------------------------------------------------
    void Broadcast( );
    //-------------------------------------------------------------------
    /// \brief Return the lock associated with condition
    //-------------------------------------------------------------------
    MutexLock::lock_type& Mutex( );
    //-------------------------------------------------------------------
    /// \brief Release lock associated with condition.
    //-------------------------------------------------------------------
    void Release( );
    //-------------------------------------------------------------------
    /// \brief Awaken a blocked thread
    //-------------------------------------------------------------------
    void Signal( );
    //-------------------------------------------------------------------
    /// \brief Timed block on condition
    //-------------------------------------------------------------------
    bool TimedWait( INT_4U Seconds );
    //-------------------------------------------------------------------
    /// \brief Block on condition
    //-------------------------------------------------------------------
    void Wait( );

  private:
    typedef pthread_cond_t cond_type;

    cond_type			m_var;
    MutexLock::lock_type	m_lock;

    ConditionalVariable( const ConditionalVariable& Source );
    ConditionalVariable& operator=( const ConditionalVariable& Source );
  };

  inline MutexLock::lock_type& ConditionalVariable::
  Mutex( )
  {
    return m_lock;
  }
}

#endif /* GENERAL__CONDITIONAL_VARIABLE_HH */

