#ifndef FrameCPP__VERSION_8__StreamRef_HH
#define FrameCPP__VERSION_8__StreamRef_HH

#include "general/types.hh"

#include "framecpp/Version8/FrameSpec.hh"

#include "framecpp/Common/StreamRef.hh"

namespace FrameCPP
{
  namespace Version_8
  {
    //-------------------------------------------------------------------
    /// \brief Common Elements of all frame structures.
    ///
    /// This type is to provide the common components of all frame
    /// structures written to a stream.
    /// This implements table 6 in section 4.3.2 of the
    /// frame specification document.
    //-------------------------------------------------------------------
    typedef Common::StreamRef2< INT_8U /* length */,
				CHAR_U /* chkType */,
				CHAR_U /* class */,
				INT_4U /* instance */ >
    StreamRef;
  } // namespace - Version_8

} // namespace FrameCPP

#endif /* FrameCPP__VERSION_8__StreamRef_HH */
