#include "framecpp/Common/Description.hh"
#include "framecpp/Common/TOCInfo.hh"

#include "framecpp/Version8/FrameSpec.hh"
#include "framecpp/Version8/FrSE.hh"
#include "framecpp/Version8/FrSH.hh"
#include "framecpp/Version8/FrTOC.hh"

#include "framecpp/Version8/STRING.hh"

using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::TOCInfo;

namespace FrameCPP
{
  namespace Version_8
  {
    //===================================================================
    //===================================================================
    FrTOCSimData::
    FrTOCSimData( )
    {
    }

    FrTOCSimData::
    FrTOCSimData( Common::IStream& Stream, INT_4U FrameCount )
    {
      nsim_type	nproc;

      Stream >> nproc;
      if ( nproc && ( nproc != FrTOC::NO_DATA_AVAILABLE ) )
      {
	//---------------------------------------------------------------
	// Read in the information
	//---------------------------------------------------------------
	std::vector< name_type >::size_type	s( nproc );
	std::vector< position_type >		positions( s * FrameCount );

	m_keys.resize( s );
	Stream >> m_keys
	       >> positions
	  ;
	//---------------------------------------------------------------
	// Move into structure.
	//---------------------------------------------------------------
	std::vector< position_type >::const_iterator
	  cur_position = positions.begin( );

	for ( key_container_type::const_iterator
		cur = m_keys.begin( ),
		last = m_keys.end( );
	      cur != last;
	      ++cur,
		cur_position += FrameCount )
	{
	  sim_info_type& i = m_info[ *cur ];
	  i.assign( cur_position, cur_position + FrameCount );
	}
	
      }
    }

    FrTOCSimData::MapSim_type::const_iterator FrTOCSimData::
    GetSim( const std::string& Channel ) const
    {
      return GetSim( ).find( Channel );
    }

    FrTOCSimData::MapSim_type::const_iterator FrTOCSimData::
    GetSim( INT_4U Channel ) const
    {
      if ( Channel >= GetSim( ).size( ) )
      {
	return GetSim( ).end( );
      }
      return GetSim( ).find( m_keys[ Channel ] );
    }

    void FrTOCSimData::
    QuerySim( const Common::TOCInfo& Info,
	       INT_4U FrameOffset,
	       INT_8U Position )
    {
      STRING	name;

      Info.TOCQuery( TOCInfo::IC_NAME, TOCInfo::DT_STRING_2, &name,
		     TOCInfo::IC_EOQ );

      sim_info_type& i( m_info[ name ] );
      i.resize( FrameOffset + 1 );
      i[ FrameOffset ] = Position;
    }

    void FrTOCSimData::
    write( Common::OStream& Stream ) const
    {
      //-----------------------------------------------------------------
      // Flatten data so it is streamable
      //-----------------------------------------------------------------
      std::vector< name_type >::size_type	s( m_info.size( ) );
      if ( s )
      {
	std::vector< name_type >::size_type
	  fc( m_info.begin( )->second.size( ) );


	std::vector< name_type >	names( s );
	std::vector< position_type >	positions( s * fc );
	//---------------------------------------------------------------
	// Copy data for streaming
	//---------------------------------------------------------------
	std::vector< name_type >::iterator
	  cur_name = names.begin( );
	std::vector< position_type >::iterator
	  cur_position = positions.begin( );

	for ( MapSim_type::const_iterator
		cur = m_info.begin( ),
		last = m_info.end( );
	      cur != last;
	      ++cur, ++cur_name,
		cur_position += fc )
	{
	  *cur_name = cur->first;
	  std::copy( cur->second.begin( ),
		     cur->second.end( ),
		     cur_position );
	}
	//---------------------------------------------------------------
	// Stream out
	//---------------------------------------------------------------
	Stream << nsim_type( s )
	       << names
	       << positions
	  ;

      }
      else
      {
	Stream << nsim_type( FrTOC::NO_DATA_AVAILABLE );
      }
    }

  } // namespace - Version_8
} // namespace - FrameCPP
