#include "framecpp/config.h"

#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/Description.hh"
#include "framecpp/Common/FrameSpec.tcc"

#include "framecpp/Version8/FrSummary.hh"
#include "framecpp/Version8/FrSE.hh"
#include "framecpp/Version8/FrSH.hh"
#include "framecpp/Version8/PTR_STRUCT.hh"

using namespace FrameCPP::Version_8;
using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::IStream;
using FrameCPP::Common::OStream;

//=======================================================================
// Static
//=======================================================================

static const FrameSpec::Info::frame_object_types s_object_id
= FrameSpec::Info::FSI_FR_SUMMARY;

//=======================================================================
// FrSummary::fr_summary_data_type
//=======================================================================

bool FrSummary::fr_summary_data_type::
operator==( const fr_summary_data_type& RHS ) const
{
#define CMP__(X) ( X == RHS.X )

  return ( ( &RHS == this )
	   || ( CMP__( name )
		&& CMP__( comment )
		&& CMP__( test )
		&& CMP__( GTime )
		&& CMP__( moments )
		&& CMP__( table )
		) )
    ;
#undef CMP__
}

//=======================================================================
// FrSummary
//=======================================================================

static const int MAX_REF = 2;

FrSummary::
FrSummary( )
  : object_type( s_object_id, StructDescription( ) )
{
}

FrSummary::
FrSummary( const FrSummary& Source )
  : object_type( s_object_id, StructDescription( ) ),
    Common::TOCInfo( Source )
{
  m_data.name = Source.m_data.name;
  m_data.comment = Source.m_data.comment;
  m_data.test = Source.m_data.test;
  m_data.GTime = Source.m_data.GTime;
  m_data.moments = Source.m_data.moments;
  m_data.table = Source.m_data.table;
}

FrSummary::
FrSummary( const std::string& name,
	   const std::string& comment,
	   const std::string& test,
	   const GPSTime& gtime )
  : object_type( s_object_id, StructDescription( ) )
{
  m_data.name = name;
  m_data.comment = comment;
  m_data.test = test;
  m_data.GTime = gtime;
}

FrSummary::
FrSummary( Previous::FrSummary& Source,
	   Common::IStream* Stream )
  : object_type( s_object_id, StructDescription( ) )
{
  m_data.name = Source.GetName( );
  m_data.comment = Source.GetComment( );
  m_data.test = Source.GetTest( );
  m_data.GTime = Source.GetGTime( );

  if ( Stream )
  {
    //-------------------------------------------------------------------
    // Modify references
    //-------------------------------------------------------------------
    Stream->ReplaceRef( RefMoments( ), Source.RefMoments( ), MAX_REF );
    Stream->ReplaceRef( RefTable( ), Source.RefTable( ), MAX_REF );
  }
}

FrSummary::
FrSummary( Common::IStream& Stream )
  : object_type( s_object_id, StructDescription( ) )
{
  Stream >> m_data.name
	 >> m_data.comment
	 >> m_data.test
	 >> m_data.GTime
	 >> m_data.moments
	 >> m_data.table
    ;
  Stream.Next( this );
}

const std::string& FrSummary::GetName( ) const
{
   return m_data.name;
}


const char* FrSummary::
ObjectStructName( ) const
{
  return StructName( );
}

const Description* FrSummary::
StructDescription( )
{
  static Description ret;

  if ( ret.size( ) == 0 )
  {
    ret( FrSH( FrSummary::StructName(), s_object_id,
	       "Summary Data Structure" ) );

    ret( FrSE( "name", "STRING" ) );
    ret( FrSE( "comment", "STRING" ) );
    ret( FrSE( "test", "STRING" ) );
    ret( FrSE( "GTimeS", "INT_4U" ) );
    ret( FrSE( "GTimeN", "INT_4U" ) );

    ret( FrSE( "moments", PTR_STRUCT::Desc( FrVect::StructName( ) ) ) );
    ret( FrSE( "table", PTR_STRUCT::Desc( FrTable::StructName( ) ) ) );

    ret( FrSE( "next", PTR_STRUCT::Desc( FrSummary::StructName( ) ) ) );

    ret( FrSE( "chkSum", CheckSumDataClass( ), CheckSumDataComment( ) ) );
  }

  return &ret;
}

void FrSummary::
#if WORKING_VIRTUAL_TOCQUERY
    TOCQuery( int InfoClass, ... ) const
#else /*  WORKING_VIRTUAL_TOCQUERY */
    vTOCQuery( int InfoClass, va_list vl ) const
#endif /*  WORKING_VIRTUAL_TOCQUERY */
{
  using Common::TOCInfo;

#if WORKING_VIRTUAL_TOCQUERY
  va_list	vl;
  va_start( vl, InfoClass );
#endif /*  WORKING_VIRTUAL_TOCQUERY */

  while ( InfoClass != TOCInfo::IC_EOQ )
  {
    int data_type = va_arg( vl, int );
    switch( data_type )
    {
    case TOCInfo::DT_STRING_2:
      {
	STRING* data = va_arg( vl, STRING* );
	switch( InfoClass )
	{
	case TOCInfo::IC_NAME:
	  *data = GetName( );
	  break;
	default:
	  goto cleanup;
	  break;
	}
      }
      break;
    default:
      // Stop processing
      goto cleanup;
    }
    InfoClass = va_arg( vl, int );
  }
 cleanup:
#if WORKING_VIRTUAL_TOCQUERY
  va_end( vl )
#endif /*  WORKING_VIRTUAL_TOCQUERY */
    ;
}

FrSummary& FrSummary::
Merge( const FrSummary& RHS )
{
  //:TODO: Need to implement Merge routine
  std::string msg( "Merge currently not implemented for " );
  msg += StructName( );

  throw std::domain_error( msg );
  return *this;
}

bool FrSummary::
operator==( const Common::FrameSpec::Object& RHS ) const
{
  return ( *this == RHS );
}

FrSummary::demote_ret_type FrSummary::
demote( INT_2U Target,
	demote_arg_type Obj,
	Common::IStream* Stream ) const
{
  if ( Target >= DATA_FORMAT_VERSION )
  {
    return Obj;
  }
  try
  {
    //-------------------------------------------------------------------
    // Copy non-reference information
    //-------------------------------------------------------------------
    // Do actual down conversion
    General::SharedPtr< Previous::FrSummary >
      retval( new Previous::FrSummary( GetName( ),
				       GetComment( ),
				       GetTest( ),
				       GetGTime( )
				       ) )
      ;
    if ( Stream )
    {
      //-----------------------------------------------------------------
      // Modify references
      //-----------------------------------------------------------------
      Stream->ReplaceRef( retval->RefMoments( ), RefMoments( ), MAX_REF );
      Stream->ReplaceRef( retval->RefTable( ), RefTable( ), MAX_REF );
    }
    //-------------------------------------------------------------------
    // Return demoted object
    //-------------------------------------------------------------------
    return retval;
  }
  catch( ... )
  {
  }
  throw
    Unimplemented( "Object* FrSummary::demote( Object* Obj ) const",
		   DATA_FORMAT_VERSION, __FILE__, __LINE__ );
}

FrSummary::promote_ret_type FrSummary::
promote( INT_2U Target,
	 promote_arg_type Obj,
	 Common::IStream* Stream ) const
{
  return Promote( Target, Obj, Stream );
}

FrameCPP::cmn_streamsize_type FrSummary::
pBytes( const Common::StreamBase& Stream ) const
{
  return
    m_data.name.Bytes( )
    + m_data.comment.Bytes( )
    + m_data.test.Bytes( )
    + sizeof( INT_4U )		// GTimeS
    + sizeof( INT_4U )		// GTimeN
    + Stream.PtrStructBytes( )	// moments
    + Stream.PtrStructBytes( )	// table
    + Stream.PtrStructBytes( )	// next
    ;
}

FrSummary* FrSummary::
pCreate( Common::IStream& Stream ) const
{
  return new FrSummary( Stream );
}

void FrSummary::
pWrite( Common::OStream& Stream ) const
{
  Stream << m_data.name
	 << m_data.comment
	 << m_data.test
	 << m_data.GTime
	 << m_data.moments
	 << m_data.table
    ;
  WriteNext( Stream );
}
