#include "framecpp/config.h"

#include "framecpp/Common/Description.hh"
#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/FrameSpec.tcc"

#include "framecpp/Version7/FrSerData.hh"

#include "framecpp/Version8/FrSerData.hh"
#include "framecpp/Version8/FrSE.hh"
#include "framecpp/Version8/FrSH.hh"
#include "framecpp/Version8/PTR_STRUCT.hh"

using namespace FrameCPP::Version_8;
using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::IStream;
using FrameCPP::Common::OStream;

//=======================================================================
// Static
//=======================================================================
static const FrameSpec::Info::frame_object_types s_object_id
= FrameSpec::Info::FSI_FR_SER_DATA;

//=======================================================================
// FrSerData::fr_ser_data_data_type
//=======================================================================

bool FrSerData::fr_ser_data_data_type::
operator==( const fr_ser_data_data_type& RHS ) const
{
#define CMP__(X) ( X == RHS.X )

  return ( ( &RHS == this )
	   || ( CMP__( name )
		&& CMP__( time )
		&& CMP__( sampleRate )
		&& CMP__( data )
		&& CMP__( serial )
		&& CMP__( table )
		) )
    ;
#undef CMP__
}

//=======================================================================
// FrSerData
//=======================================================================

static const int MAX_REF = 2;

FrSerData::
FrSerData( )
  : object_type( s_object_id, StructDescription( ) )
{
}

FrSerData::
FrSerData( const FrSerData& Source )
  : object_type( s_object_id, StructDescription( ) ),
    Common::TOCInfo( Source )
{
  m_data.name = Source.m_data.name;
  m_data.time = Source.m_data.time;
  m_data.sampleRate = Source.m_data.sampleRate;
  m_data.data = Source.m_data.data;
  m_data.serial = Source.m_data.serial;
  m_data.table = Source.m_data.table;
}

FrSerData::
FrSerData( const std::string& name, const GPSTime& time, REAL_8 sampleRate )
  : object_type( s_object_id, StructDescription( ) )
{
  m_data.name = name;
  m_data.time = time;
  m_data.sampleRate = sampleRate;
}


FrSerData::
FrSerData( Previous::FrSerData& Source, Common::IStream* Stream )
  : object_type( s_object_id, StructDescription( ) )
{
  m_data.name = Source.GetName( );
  m_data.time = Source.GetTime( );
  m_data.sampleRate = Source.GetSampleRate( );
  m_data.data = Source.GetData( );
  if ( Stream )
  {
    //-------------------------------------------------------------------
    // Modify references
    //-------------------------------------------------------------------
    Stream->ReplaceRef( RefSerial( ), Source.RefSerial( ), MAX_REF );
    Stream->ReplaceRef( RefTable( ), Source.RefTable( ), MAX_REF );
  }
}

FrSerData::
FrSerData( Common::IStream& Stream )
  : object_type( s_object_id, StructDescription( ) )
{
      Stream >> m_data.name
	     >> m_data.time
	     >> m_data.sampleRate
	     >> m_data.data
	     >> m_data.serial
	     >> m_data.table
	;
      Stream.Next( this );
}

const char* FrSerData::
ObjectStructName( ) const
{
  return StructName( );
}

const Description* FrSerData::
StructDescription( )
{
  static Description ret;

  if ( ret.size( ) == 0 )
  {
    ret( FrSH( FrSerData::StructName( ), s_object_id,
	       "Serial Data Structure" ) );

    ret( FrSE( "name", "STRING" ) );
    ret( FrSE( "timeSec", "INT_4U" ) );
    ret( FrSE( "timeNsec", "INT_4U" ) );
    ret( FrSE( "sampleRate", "REAL_8" ) );
    ret( FrSE( "data", "STRING" ) );

    ret( FrSE( "serial", PTR_STRUCT::Desc( FrVect::StructName( ) ) ) );
    ret( FrSE( "table", PTR_STRUCT::Desc( FrTable::StructName( ) ) ) );

    ret( FrSE( "next", PTR_STRUCT::Desc( FrSerData::StructName( ) ) ) );

    ret( FrSE( "chkSum", CheckSumDataClass( ), CheckSumDataComment( ) ) );
  }

  return &ret;
}

void FrSerData::
#if WORKING_VIRTUAL_TOCQUERY
    TOCQuery( int InfoClass, ... ) const
#else /*  WORKING_VIRTUAL_TOCQUERY */
    vTOCQuery( int InfoClass, va_list vl ) const
#endif /*  WORKING_VIRTUAL_TOCQUERY */
{
  using Common::TOCInfo;

#if WORKING_VIRTUAL_TOCQUERY
  va_list	vl;
  va_start( vl, InfoClass );
#endif /*  WORKING_VIRTUAL_TOCQUERY */

  while ( InfoClass != TOCInfo::IC_EOQ )
  {
    int data_type = va_arg( vl, int );
    switch( data_type )
    {
    case TOCInfo::DT_STRING_2:
      {
	STRING* data = va_arg( vl, STRING* );
	switch( InfoClass )
	{
	case TOCInfo::IC_NAME:
	  *data = GetName( );
	  break;
	default:
	  goto cleanup;
	  break;
	}
      }
      break;
    default:
      // Stop processing
      goto cleanup;
    }
    InfoClass = va_arg( vl, int );
  }
 cleanup:
#if WORKING_VIRTUAL_TOCQUERY
  va_end( vl )
#endif /*  WORKING_VIRTUAL_TOCQUERY */
    ;
}

bool FrSerData::
operator==( const Common::FrameSpec::Object& RHS ) const
{
  return ( *this == RHS );
}

const std::string& FrSerData::
GetName() const
{ 
   return m_data.name;
}


FrSerData& FrSerData::
Merge( const FrSerData& RHS )
{
  //:TODO: Need to implement Merge routine
  std::string msg( "Merge currently not implemented for " );
  msg += StructName( );

  throw std::domain_error( msg );
  return *this;
}

FrSerData::demote_ret_type FrSerData::
demote( INT_2U Target,
	demote_arg_type Obj,
	Common::IStream* Stream ) const
{
  if ( Target >= DATA_FORMAT_VERSION )
  {
    return Obj;
  }
  try
  {
    //-------------------------------------------------------------------
    // Copy non-reference information
    //-------------------------------------------------------------------
    // Do actual down conversion
    General::SharedPtr< Previous::FrSerData >
      retval( new Previous::FrSerData( GetName( ),
				       GetTime( ),
				       GetSampleRate( )
				       ) )
      ;
    retval->SetData( GetData( ) );
    if ( Stream )
    {
      //-----------------------------------------------------------------
      // Modify references
      //-----------------------------------------------------------------
      Stream->ReplaceRef( retval->RefSerial( ), RefSerial( ), MAX_REF );
      Stream->ReplaceRef( retval->RefTable( ), RefTable( ), MAX_REF );
    }
    //-------------------------------------------------------------------
    // Return demoted object
    //-------------------------------------------------------------------
    return retval;
  }
  catch( ... )
  {
  }
  throw
    Unimplemented( "Object* FrSerData::Demote( Object* Obj ) const",
		   DATA_FORMAT_VERSION, __FILE__, __LINE__ );
}

FrSerData::promote_ret_type FrSerData::
promote( INT_2U Target,
	 promote_arg_type Obj,
	 Common::IStream* Stream ) const
{
  return Promote( Target, Obj, Stream );
}

FrameCPP::cmn_streamsize_type FrSerData::
pBytes( const Common::StreamBase& Stream ) const
{
  return
    m_data.name.Bytes( )
    + sizeof( INT_4U )		// timeSec
    + sizeof( INT_4U )		// timeNsec
    + sizeof( m_data.sampleRate )
    + m_data.data.Bytes( )
    + Stream.PtrStructBytes( )	// serial
    + Stream.PtrStructBytes( )	// table
    + Stream.PtrStructBytes( )	// next
    ;
}

FrSerData* FrSerData::
pCreate( Common::IStream& Stream ) const
{
  return new FrSerData( Stream );
}

void FrSerData::
pWrite( Common::OStream& Stream ) const
{
  Stream << m_data.name
	 << m_data.time
	 << m_data.sampleRate
	 << m_data.data
	 << m_data.serial
	 << m_data.table
    ;
  WriteNext( Stream );
}

