#include "framecpp/config.h"

#include "framecpp/Common/Description.hh"
#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/FrameSpec.tcc"

#include "framecpp/Version8/FrRawData.hh"
#include "framecpp/Version8/FrSE.hh"
#include "framecpp/Version8/FrSH.hh"
#include "framecpp/Version8/PTR_STRUCT.hh"

using namespace FrameCPP::Version_8;
using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::IStream;
using FrameCPP::Common::OStream;

#define TRACE_MEMORY 0
#if TRACE_MEMORY
#define MEM_ALLOCATE() std::cerr << "MEMORY: Allocate: " << FrRawData::getStaticName() << " " << (void*)this << std::endl;
#define MEM_DELETE() std::cerr << "MEMORY: Delete: " << FrRawData::getStaticName() << " " << (void*)this << std::endl;
#else
#define MEM_ALLOCATE()
#define MEM_DELETE()
#endif

static const int MAX_REF = 5;

FrRawData::
FrRawData( )
  : object_type( CLASS_ID, StructDescription( ) )
{
  MEM_ALLOCATE( );
}

FrRawData::
FrRawData( const FrRawData& rawData )
  : object_type( CLASS_ID, StructDescription( ) )
{
  MEM_ALLOCATE( );
  m_data.name = rawData.m_data.name;
  m_data.firstSer = rawData.m_data.firstSer;
  m_data.firstAdc = rawData.m_data.firstAdc;
  m_data.firstTable = rawData.m_data.firstTable;
  m_data.logMsg = rawData.m_data.logMsg;
  m_data.more = rawData.m_data.more;
}

FrRawData::
FrRawData( const std::string& name )
  : object_type( CLASS_ID, StructDescription( ) )
{
  MEM_ALLOCATE( );
  m_data.name = name;
}

FrRawData::
FrRawData( Previous::FrRawData& Source,
	   Common::IStream* Stream )
  : object_type( CLASS_ID, StructDescription( ) )
{
  m_data.name = Source.GetName( );
  if ( Stream )
  {
    //-------------------------------------------------------------------
    // Modify references
    //-------------------------------------------------------------------
    Stream->ReplaceRef( RefFirstSer( ), Source.RefFirstSer( ), MAX_REF );
    Stream->ReplaceRef( RefFirstAdc( ), Source.RefFirstAdc( ), MAX_REF );
    Stream->ReplaceRef( RefFirstTable( ), Source.RefFirstTable( ), MAX_REF );
    Stream->ReplaceRef( RefLogMsg( ), Source.RefLogMsg( ), MAX_REF );
    Stream->ReplaceRef( RefMore( ), Source.RefMore( ), MAX_REF );
  }
}

FrRawData::
FrRawData( Common::IStream& Stream )
  : object_type( CLASS_ID, StructDescription( ) )
{
  Stream
    >> m_data.name
    >> m_data.firstSer
    >> m_data.firstAdc
    >> m_data.firstTable
    >> m_data.logMsg
    >> m_data.more
    ;
}

FrRawData::
FrRawData( const Previous::FrRawData& Source )
  : object_type( CLASS_ID, StructDescription( ) )
{
  //---------------------------------------------------------------------
  // Retrieve pieces from the previous version
  //---------------------------------------------------------------------
  m_data.name = Source.GetName( );
  //---------------------------------------------------------------------
  // Do not worry about reference objects as the stream reader will
  //   be handling those.
  //---------------------------------------------------------------------
}

FrRawData::
~FrRawData( )
{
  MEM_DELETE( );
}

const std::string& FrRawData::GetName() const
{ 
   return m_data.name;
}

const char* FrRawData::
ObjectStructName( ) const
{
  return StructName( );
}

const Description* FrRawData::
StructDescription( )
{
  static Description ret;

  if ( ret.size( ) == 0 )
  {
    ret( FrSH( FrRawData::StructName(), FrRawData::CLASS_ID,
	       "Raw Data Structure" ) );

    ret( FrSE( "name", "STRING",
	       "" ) );
    ret( FrSE( "firstSer", PTR_STRUCT::Desc( FrSerData::StructName( ) ),
	       "") );
    ret( FrSE( "firstAdc", PTR_STRUCT::Desc( FrAdcData::StructName( ) ),
	       "" ) );
    ret( FrSE( "firstTable", PTR_STRUCT::Desc( FrTable::StructName( ) ),
	       "" ) );
    ret( FrSE( "logMsg", PTR_STRUCT::Desc( FrMsg::StructName( ) ),
	       "" ) );
    ret( FrSE( "more", PTR_STRUCT::Desc( FrVect::StructName( ) ),
	       "" ) );

    ret( FrSE( "chkSum", CheckSumDataClass( ), CheckSumDataComment( ) ) );
  }

  return &ret;
}

bool FrRawData::
operator==( const Common::FrameSpec::Object& RHS ) const
{
  return compare( *this, RHS );
}

FrRawData::demote_ret_type FrRawData::
demote( INT_2U Target,
	demote_arg_type Obj,
	Common::IStream* Stream  ) const
{
  if ( Target >= DATA_FORMAT_VERSION )
  {
    return Obj;
  }
  try
  {
    //-------------------------------------------------------------------
    // Copy non-reference information
    //-------------------------------------------------------------------
    // Do actual down conversion
    General::SharedPtr< Previous::FrRawData >
      retval( new Previous::FrRawData( GetName( )
				       ) )
      ;
    if ( Stream )
    {
      //-----------------------------------------------------------------
      // Modify references
      //-----------------------------------------------------------------
      Stream->ReplaceRef( retval->RefFirstSer( ), RefFirstSer( ), MAX_REF );
      Stream->ReplaceRef( retval->RefFirstAdc( ), RefFirstAdc( ), MAX_REF );
      Stream->ReplaceRef( retval->RefFirstTable( ), RefFirstTable( ), MAX_REF );
      Stream->ReplaceRef( retval->RefLogMsg( ), RefLogMsg( ), MAX_REF );
      Stream->ReplaceRef( retval->RefMore( ), RefMore( ), MAX_REF );
    }
    //-------------------------------------------------------------------
    // Return demoted object
    //-------------------------------------------------------------------
    return retval;
  }
  catch( ... )
  {
  }
  throw
    Unimplemented( "Object* FrRawData::Demote( Object* Obj ) const",
		   DATA_FORMAT_VERSION, __FILE__, __LINE__ );
}

FrRawData::promote_ret_type FrRawData::
promote( INT_2U Target,
	 promote_arg_type Obj,
	 Common::IStream* Stream ) const
{
  return Promote( Target, Obj, Stream );
}

FrameCPP::cmn_streamsize_type  FrRawData::
pBytes( const Common::StreamBase& Stream ) const
{
  cmn_streamsize_type retval
    = m_data.name.Bytes( ) +
    + Stream.PtrStructBytes( )	// firstSer
    + Stream.PtrStructBytes( )	// firstAdc
    + Stream.PtrStructBytes( )	// firstTable
    + Stream.PtrStructBytes( )	// logMsg
    + Stream.PtrStructBytes( )	// more
    ;
  return retval;
}

FrRawData* FrRawData::
pCreate( Common::IStream& Stream ) const
{
  return new FrRawData( Stream );
}

void FrRawData::
pWrite( Common::OStream& Stream ) const
{
  Stream
    << m_data.name
    << m_data.firstSer
    << m_data.firstAdc
    << m_data.firstTable
    << m_data.logMsg
    << m_data.more
    ;
}

FrRawData::fr_raw_data_type::
fr_raw_data_type( )
  : firstSer( false ),
    firstAdc( false )
{
}
