#ifndef FrameCPP_VERSION_3_FrDetector_HH
#define FrameCPP_VERSION_3_FrDetector_HH

#if ! defined(SWIGIMPORTED)
#include <string>
#include <vector>
#endif /* ! defined(SWIGIMPORTED) */

#include "general/types.hh"

#include "framecpp/FrameCPP.hh"

#include "framecpp/Common/SearchContainer.hh"
#include "framecpp/Common/TOCInfo.hh"
#include "framecpp/Common/FrDetector.hh"

#include "framecpp/Version3/STRING.hh"

#include "framecpp/Version3/FrVect.hh"

namespace FrameCPP
{
  namespace Version_3
  {
    class FrDetector
      : public Common::FrDetector,
	public Common::TOCInfo
    {
    public:
      typedef Common::SearchContainer< FrVect, &FrVect::GetName >
      more_type;
      typedef more_type::iterator aux_iterator;
      typedef more_type::const_iterator const_aux_iterator;

      //: Default constructor
      FrDetector( );

      FrDetector( const std::string& Name,
		  const INT_2S LongitudeD,
		  const INT_2S LongitudeM,
		  const REAL_4 LongitudeS,
		  const INT_2S LatitudeD,
		  const INT_2S LatitudeM,
		  const REAL_4 LatitudeS,
		  const REAL_4 Elevation,
		  const REAL_4 ArmXazimuth,
		  const REAL_4 ArmYazimuth,
		  const REAL_4 ArmLength );

      FrDetector( const FrDetector& detector );

      static const char* StructName( );

      static const Common::Description* StructDescription( );

      //: Number of bytes needed to write this structure
      cmn_streamsize_type Bytes( const Common::StreamBase& Stream) const;

      virtual FrDetector* Create( istream_type& Stream ) const;

      virtual const char* ObjectStructName( ) const;

      virtual void Write( ostream_type& Stream ) const;

      const std::string& GetName( ) const;
      INT_2S GetLongitudeD( ) const;
      INT_2S GetLongitudeM( ) const;
      REAL_4 GetLongitudeS( ) const;
      INT_2S GetLatitudeD( ) const;
      INT_2S GetLatitudeM( ) const;
      REAL_4 GetLatitudeS( ) const;
      REAL_4 GetElevation( ) const;
      REAL_4 GetArmXazimuth( ) const;
      REAL_4 GetArmYazimuth( ) const;
      REAL_4 GetArmLength( ) const;

      const more_type& RefMore( ) const;
      more_type& RefMore( );
   
      //: Merge with another FrDetector
      FrDetector& Merge( const FrDetector& RHS );

      static promote_ret_type
      Promote( INT_2U Source,
	       promote_arg_type Obj,
	       Common::IStream* Stream );

      /// \brief comparison operator
      bool operator==( const FrDetector& RHS ) const;

      /// \brief comparison operator
      virtual bool operator==( const Common::FrameSpec::Object& Obj ) const;

#if WORKING_VIRTUAL_TOCQUERY
      virtual void TOCQuery( int InfoClass, ... ) const;
#endif /* WORKING_VIRTUAL_TOCQUERY */

    protected:
      /// \brief Down grade an object
      virtual demote_ret_type
      demote( INT_2U Target,
	      demote_arg_type Obj,
	      istream_type* Stream ) const;

      /// \brief Upgrade an object
      virtual promote_ret_type
      promote( INT_2U Source,
	       promote_arg_type Obj,
	       istream_type* Stream ) const;

#if ! WORKING_VIRTUAL_TOCQUERY
      virtual void vTOCQuery( int InfoClass, va_list vl ) const;
#endif /* ! WORKING_VIRTUAL_TOCQUERY */

    private:
      using Common::FrameSpec::Object::Create;

      struct fr_detector_data_type {
	bool operator==( const fr_detector_data_type& RHS ) const;
	STRING		name;
	INT_2S		longitudeD;
	INT_2S		longitudeM;
	REAL_4		longitudeS;
	INT_2S		latitudeD;
	INT_2S		latitudeM;
	REAL_4		latitudeS;
	REAL_4		elevation;
	REAL_4		armXazimuth;
	REAL_4		armYazimuth;
	REAL_4		armLength;
	more_type	more;
      };

      fr_detector_data_type	m_data;

      FrDetector( istream_type& Stream );
    };

    inline const char* FrDetector::
    StructName( )
    {
      static const char* name = "FrDetector";
      return name;
    }

    inline INT_2S FrDetector::
    GetLongitudeD( ) const
    {
      return m_data.longitudeD;
    }

    inline INT_2S FrDetector::
    GetLongitudeM( ) const
    {
      return m_data.longitudeD;
    }

    inline REAL_4 FrDetector::
    GetLongitudeS( ) const
    {
      return m_data.longitudeS;
    }

    inline INT_2S FrDetector::
    GetLatitudeD( ) const
    {
      return m_data.latitudeD;
    }

    inline INT_2S FrDetector::
    GetLatitudeM( ) const
    {
      return m_data.latitudeM;
    }

    inline REAL_4 FrDetector::
    GetLatitudeS( ) const
    {
      return m_data.latitudeS;
    }

    inline REAL_4 FrDetector::
    GetElevation( ) const
    {
      return m_data.elevation;
    }

    inline REAL_4 FrDetector::
    GetArmXazimuth( ) const
    {
      return m_data.armXazimuth;
    }

    inline REAL_4 FrDetector::
    GetArmYazimuth( ) const
    {
      return m_data.armYazimuth;
    }

    inline REAL_4 FrDetector::
    GetArmLength( ) const
    {
      return m_data.armLength;
    }

    inline const FrDetector::more_type& FrDetector::
    RefMore( ) const
    {
      return m_data.more;
    }

    inline FrDetector::more_type& FrDetector::
    RefMore( )
    {
      return m_data.more;
    }

    inline FrDetector::promote_ret_type FrDetector::
    Promote( INT_2U Source,
	     promote_arg_type Obj,
	     Common::IStream* Stream )
    {
      return Common::PromoteObject( DATA_FORMAT_VERSION, Source, Obj );
    }

    inline bool FrDetector::
    operator==( const FrDetector& RHS ) const
    {
      return ( m_data == RHS.m_data );
    }
  } // namespace - Version_3
} // namespace FrameCPP
#endif /* FrameCPP_VERSION_3_FrDetector_HH */
