/* -*- mode: c++ -*- */
#ifndef FR_HISTORY_I
#define FR_HISTORY_I

%module frameCPP

%{
#include "general/types.hh"
#include "framecpp/FrHistory.hh"

using namespace FrameCPP;
%}

%import "framecpp/FrameCPP.hh"
%include "framecpp/FrHistory.hh"

%SharedPtr(FrHistory)


%feature("autodoc",
"""
FrHistory (History Data) implementation of the frame specification.

  Attributes:

    name     Name of history record. NOTE: When a FrHistory is linked
             to an FrProcData, its name variable must be the FrProcData
             channel name.
    comment  Program name and relevant comments needed to
             define post-processing.

""" ) FrHistory;

class FrHistory
{
public:

  FrHistory( );
  FrHistory( const std::string& Name,
	     INT_4U Time,
	     const std::string& Comment );
	     
  const std::string& GetName() const; 
  const std::string& GetComment( ) const;

  LDAS_PROPERTY_READ_ONLY("name",GetName)
  LDAS_PROPERTY_READ_ONLY("comment",GetComment)
};

#endif /* FR_HISTORY_I */
