#ifndef FRAME_CPP_INTERFACE__FRAME_CPP_HH
#define FRAME_CPP_INTERFACE__FRAME_CPP_HH

#if defined(__cplusplus)
#if ! defined(SWIGIMPORTED)
#include <string>
#endif /* ! defined(SWIGIMPORTED) */
#endif /* defined(__cplusplus) */

#include "general/types.hh"

#if ! defined(SWIGIMPORTED)
#include "framecpp/config.h"

#include "framecpp/Common/FrameSpec.hh"
#endif /* ! defined(SWIGIMPORTED) */

#define FRAME_SPEC_MIN		3
#define FRAME_SPEC_CURRENT	8
#define FRAME_SPEC_MAX		8

#if defined(__cplusplus)
//-----------------------------------------------------------------------
/// \brief I/O library for implementing the LIGO/Virgo frame specification.
///
/// All elements described within this namespace are intended to
/// implement the various frame specifications created by LIGO/Virgo.
//-----------------------------------------------------------------------
namespace FrameCPP
{
  //---------------------------------------------------------------------
  /// \brief LdasException error codes for libframecpp.
  //---------------------------------------------------------------------
  enum CODE {
    BAD_FRAME_FILE
  };

  //---------------------------------------------------------------------
  /// \brief enumerated type describing the byte ordering
  //---------------------------------------------------------------------
  enum byte_order_type {
    BYTE_ORDER_BIG_ENDIAN,
    BYTE_ORDER_LITTLE_ENDIAN,
#if WORDS_BIGENDIAN
    BYTE_ORDER_HOST = BYTE_ORDER_BIG_ENDIAN
#else	/* WORDS_BIGENDIAN */
    BYTE_ORDER_HOST = BYTE_ORDER_LITTLE_ENDIAN
#endif	/* WORDS_BIGENDIAN */

  };

  //---------------------------------------------------------------------
  // Typedef for version information
  //---------------------------------------------------------------------

  typedef CHAR_U version_type;
  typedef Common::FrameSpec::Object Base;

  //---------------------------------------------------------------------
  // Constants representing version information
  //---------------------------------------------------------------------
  // Establish the default version namespace

#if FRAME_SPEC_CURRENT == 3
  namespace Version_3 {}
  namespace Version = Version_3;
#elif FRAME_SPEC_CURRENT == 4
  namespace Version_4 {}
  namespace Version = Version_4;
#elif FRAME_SPEC_CURRENT == 5
  namespace Version_5 {}
  namespace Version = Version_5;
#elif FRAME_SPEC_CURRENT == 6
  namespace Version_6 {}
  namespace Version = Version_6;
#elif FRAME_SPEC_CURRENT == 7
  namespace Version_7 {}
  namespace Version = Version_7;
#elif FRAME_SPEC_CURRENT == 8
  namespace Version_8 {}
  namespace Version = Version_8;
#else
#error Version namespace not defined for FRAME_SPEC_CURRENT
#endif /* PRAME_SPEC_CURRENT */

#ifndef SWIG
  //---------------------------------------------------------------------
  /// \brief The earliest supported frame specification
  ///
  /// This is the earliest feature complete implementation of the
  /// frame specification.
  //---------------------------------------------------------------------
  const version_type FrameSpecMinimum( FRAME_SPEC_MIN );

  //---------------------------------------------------------------------
  /// \brief Currentently supported frame specification
  ///
  /// This is the latest version of the frame specification that is
  /// fully supported.
  /// By default, this version of the frame specification will be
  /// used to create memory objects.
  /// Also, output data streams will be generated according to this
  /// version of the frame specification.
  //---------------------------------------------------------------------
  const version_type FrameSpecCurrent( FRAME_SPEC_CURRENT );

  //---------------------------------------------------------------------
  /// \brief Maximum supported frame spec
  ///
  /// This represents the maximum frame specification this is at least
  /// partially implemented.
  /// If it exceeds FrmaeSpecCurrent, it is not guaranteed to be complete.
  /// It allows for implementin and testing of Alpha and Beta
  /// versions of the frame specification.
  //---------------------------------------------------------------------
  const version_type FrameSpecMaximum( FRAME_SPEC_MAX );

  //---------------------------------------------------------------------
  /// \brief Byte ordering of host
  //---------------------------------------------------------------------
  const int HostByteOrder( BYTE_ORDER_HOST );


  //---------------------------------------------------------------------
  /// \brief Get the version of frameCPP
  //---------------------------------------------------------------------
  std::string GetVersion( );

  //---------------------------------------------------------------------
  /// \brief Get the CVS date for this version of frameCPP
  //---------------------------------------------------------------------
  std::string GetCVSDate( );

  //---------------------------------------------------------------------
  /// \brief Get the date when frameCPP was built.
  //---------------------------------------------------------------------
  std::string GetBuildDate( );

  //---------------------------------------------------------------------
  /// \brief Return the data format version
  //---------------------------------------------------------------------
  INT_2U GetDataFormatVersion( );

  //---------------------------------------------------------------------
  /// \brief Return the minor version of the frame library
  //---------------------------------------------------------------------
  INT_2U GetFrameLibraryMinorVersion( );

  //---------------------------------------------------------------------
  /// \brief Initialize the C++ Interface
  //---------------------------------------------------------------------
  void Initialize( );
#endif /* SWIG */

} // namespace FrameCPP

#endif /* defined(__cplusplus) */
#endif	/* FRAME_CPP_INTERFACE__FRAME_CPP_HH */
