#ifndef FrameCPP__COMMON__StreamFilter_HH
#define FrameCPP__COMMON__StreamFilter_HH

#include "framecpp/config.h"

#include "general/types.hh"

#define DEBUG_STREAM_FILTER 0

namespace FrameCPP
{
  namespace Common
  {
    class StreamFilter
    {
    public:
      StreamFilter( );

      virtual ~StreamFilter( );

      const void* Offset( ) const;
      /// \brief
      const void* Offset( const void* Pos );

      /// \brief Public filter call
      void pubfilter( const char* Buffer, INT_8U Size );

    protected:
      virtual void filter( const char* Buffer, INT_8U Size ) = 0;

      const void* m_buffer_pos;
#if DEBUG_STREAM_FILTER
      INT_8U	m_bytes_filtered;
#endif /* DEBUG_STREAM_FILTER */
    };

    inline const void* StreamFilter::
    Offset( ) const
    {
      return m_buffer_pos;
    }

    inline const void* StreamFilter::
    Offset( const void* Pos )
    {
      const void* retval = m_buffer_pos;

      m_buffer_pos = Pos;
      return retval;
    }
  } // namespace - Common
} // namespace - FrameCPP
#endif /* FrameCPP__COMMON__StreamFilter_HH */
