/* -*- mode: c++; c-basic-offset: 2; indent-tabs-mode: nil; -*- */

#include "framecpp/Common/FrameBuffer.hh"

#include <cassert>

namespace FrameCPP
{
  namespace Common
  {
    //-------------------------------------------------------------------
    // Specialization of Open based on std::filebuf
    //-------------------------------------------------------------------

    template<> FrameBuffer< std::filebuf >*
    FrameBuffer< std::filebuf >::
    close( )
    {
      if ( std::filebuf::close( ) != (std::filebuf*)NULL )
      {
	bufferId( "" );
	return this;
      }
      return (buffer_type*)NULL;
    }

    template<> FrameBuffer< std::filebuf >*
    FrameBuffer< std::filebuf >::
    open( const std::string& Filename, std::ios::openmode Mode )
    {
      std::ostringstream	msg;

      element_type::open( Filename.c_str( ), Mode );
      if ( element_type::is_open( ) == false )
      {
	msg << "Unable to open file: " << Filename
	    << " (" << General::System::ErrnoMessage( ) << ")"
	  ;
        std::runtime_error err( msg.str( ).c_str( ) );
	throw err;
      }
      bufferId( Filename );
      return this;
    }

    template<> void
    FrameBuffer< std::filebuf >::
    UseMemoryMappedIO( bool Value )
    {
    }

  } // namespace Common

} // namespace FrameCPP

namespace FrameCPP
{
  namespace Common
  {
    //-------------------------------------------------------------------
    // Specialization of Open based on General::filebuf
    //-------------------------------------------------------------------

    template<> void
    FrameBuffer< General::filebuf >::
    UseMemoryMappedIO( bool Value )
    {
      General::filebuf::UseMemoryMappedIO( Value );
    }

    template<> FrameBuffer< General::filebuf >*
    FrameBuffer< General::filebuf >::
    close( )
    {
      if ( General::filebuf::close( ) != (General::filebuf*)NULL )
      {
	bufferId( "" );
	return this;
      }
      return (buffer_type*)NULL;
    }

    template<> FrameBuffer< General::filebuf >*
    FrameBuffer< General::filebuf >::
    open( const std::string& Filename, std::ios::openmode Mode )
    {
      General::filebuf::open( Filename.c_str( ), Mode );
      if ( General::filebuf::is_open( ) == false )
      {
	std::ostringstream	msg;

	msg << "Unable to open file: " << Filename
	    << " (" << General::System::ErrnoMessage( ) << ")"
	  ;
	throw std::runtime_error( msg.str( ) );
      }
      bufferId( Filename );
      return this;
    }

  } // namespace Common

} // namespace FrameCPP

template class FrameCPP::Common::FrameBuffer< General::filebuf >;
