#ifndef FrameCPP__COMMON__Array_HH
#define FrameCPP__COMMON__Array_HH

#if ! defined(SWIGIMPORTED)
#include <vector>
#endif /* ! defined(SWIGIMPORTED) */

#include "framecpp/Common/FrameSpec.hh"

namespace FrameCPP
{
  namespace Common
  {
    template< typename N, typename T >
    class Array
      : public std::vector< T >
    {
    public:
      typedef N n_size_type;
      typedef typename std::vector< T >::const_iterator	const_iterator;

      cmn_streamsize_type Bytes( const StreamBase& Stream ) const;

      cmn_streamsize_type bytes( ) const;

      bool operator==( const Array& RHS ) const;
    private:
    };

    template< typename N, typename T>
    cmn_streamsize_type Array< N, T >::
    Bytes( const StreamBase& Stream ) const
    {
      cmn_streamsize_type	retval = sizeof( n_size_type );

      for ( const_iterator
	      cur = this->begin( ),
	      last = this->end( );
	    cur != last;
	    ++cur )
      {
	retval += cur->Bytes( Stream );
      }
      return retval;
    }

    template< typename N, typename T>
    cmn_streamsize_type Array< N, T >::
    bytes( ) const
    {
      cmn_streamsize_type	retval = sizeof( n_size_type );

      for ( const_iterator
	      cur = this->begin( ),
	      last = this->end( );
	    cur != last;
	    ++cur )
      {
	retval += cur->bytes( );
      }
      return retval;
    }

    template< typename N, typename T>
    bool Array< N, T >::
    operator==( const Array& RHS ) const
    {
      bool	retval = ( &RHS == this );

      if ( retval == false )
      {
	if ( this->size( ) == RHS.size( ) )
	{
	  retval = true;
	  for ( const_iterator
		  rhs_cur = RHS.begin( ),
		  cur = this->begin( ),
		  last = this->end( );
		cur != last;
		++cur,
		++rhs_cur )
	  {
	    if ( ! ( *cur == *rhs_cur ) )
	    {
	      retval = false;
	      break;
	    }
	  }
	}
      }
      return retval;
    }
  } // namespace - Common
} // namespace - FrameCPP
#endif /* FrameCPP__COMMON__Array_HH */
