#ifndef FRAME_CPP_INTERFACE__FR_EVENT_INTERNAL_HH
#define FRAME_CPP_INTERFACE__FR_EVENT_INTERNAL_HH

#include "general/SharedPtr.hh"

namespace FrameC
{
  struct FrEvent
    : public Handle
  {
    typedef FrameCPP::FrEvent			data_core_t;
    typedef General::SharedPtr< data_core_t >	data_t;
#if WORKING
    typedef data_core_t::time_t			time_t;
#endif /* WORKING */

    data_t	m_data;

    FrEvent( );

    FrEvent( const fr_event_name_t Name,
	     const fr_event_comment_t Comment,
	     const fr_event_inputs_t Inputs,
	     const fr_event_gtime_t GTime,
	     const fr_event_time_before_t TimeBefore,
	     const fr_event_time_after_t TimeAfter,
	     const fr_event_event_status_t EventStatus,
	     const fr_event_amplitude_t Amplitude,
	     const fr_event_probability_t Probability,
	     const fr_event_statistics_t Statistics,
	     const fr_event_n_param_t NParam,
	     const fr_event_parameters_t* Parameters );
	       
  };

  template<>
  inline pointer_type
  PointerType( FrEvent* Value )
  {
    return POINTER_FR_EVENT;
  }

}

#endif /* FRAME_CPP_INTERFACE__FR_EVENT_INTERNAL_HH */
