#ifndef FRAME_CPP_INTERFACE__FR_DETECTOR_INTERNAL_HH
#define FRAME_CPP_INTERFACE__FR_DETECTOR_INTERNAL_HH

#include "general/SharedPtr.hh"

namespace FrameC
{
  struct FrDetector
    : public Handle
  {
    typedef FrameCPP::FrDetector		data_core_t;
    typedef General::SharedPtr< data_core_t >	data_t;

    data_t					m_data;

    FrDetector( );

    FrDetector( const char* restrict name,
		const char* restrict prefix,
		fr_detector_latitude_t latitude,
		fr_detector_longitude_t longitude,
		fr_detector_elevation_t elevation,
		fr_detector_arm_x_azimuth_t azimuth_x,
		fr_detector_arm_y_azimuth_t azimuth_y,
		fr_detector_arm_x_altitude_t altitude_x,
		fr_detector_arm_y_altitude_t altitude_y,
		fr_detector_arm_x_midpoint_t midpoint_x,
		fr_detector_arm_y_midpoint_t midpoint_y,
		fr_detector_localtime_t localtime );

    FrDetector( const data_core_t& Source );

    virtual ~FrDetector( );

    void Read( fr_file_t* restrict Stream,
	       const char* restrict Name );
  };


  template<>
  inline pointer_type
  PointerType( FrDetector* Value )
  {
    return POINTER_FR_DETECTOR;
  }

} /* namespace FrameC */

#endif /* FRAME_CPP_INTERFACE__FR_DETECTOR_INTERNAL_HH */
