#include "MountPointStatus.cc"

#include "general/unittest.h"

General::UnitTest Test;

void
Unmanaged( )
{
  bool status = false;

  try
  {
    mount_points_type	m;
    m[ "/junk1" ] = NULL;
    m[ "/junk3" ] = NULL;

    mount_points_type::const_iterator i = m.Locate( "/junk2" );

    status = ( i == m.end( ) );
  }
  catch( const std::range_error& e )
  {
    status = true;
  }
  catch( ... )
  {
    status = false;
  }
  Test.Check( status )
    << "Testing of unmanaged directory"
    << std::endl
    ;
}

void
UnmanagedHead( )
{
  bool status = false;

  try
  {
    mount_points_type	m;
    m[ "/junk1" ] = NULL;
    m[ "/junk3" ] = NULL;

    mount_points_type::const_iterator i = m.Locate( "/aaa" );

    status = ( i == m.end( ) );
  }
  catch( const std::range_error& e )
  {
    status = true;
  }
  catch( ... )
  {
    status = false;
  }
  Test.Check( status )
    << "Testing of unmanaged head directory"
    << std::endl
    ;
}

void
UnmanagedTail( )
{
  bool status = false;

  try
  {
    mount_points_type	m;
    m[ "/junk1" ] = NULL;
    m[ "/junk3" ] = NULL;

    mount_points_type::const_iterator i = m.Locate( "/zzz" );

    status = ( i == m.end( ) );
  }
  catch( const std::range_error& e )
  {
    status = true;
  }
  catch( ... )
  {
    status = false;
  }
  Test.Check( status )
    << "Testing of unmanaged tail directory"
    << std::endl
    ;
}

void
RootDirectory( )
{
  bool status = false;

  try
  {
    mount_points_type	m;
    m[ "/junk1" ] = NULL;
    m[ "/junk2" ] = NULL;
    m[ "/junk3" ] = NULL;

    mount_points_type::const_iterator i = m.Locate( "/junk2" );

    status = ( ( i != m.end( ) )
	       && ( i->first.compare( "/junk2" ) == 0 ) );
  }
  catch( ... )
  {
    status = false;
  }
  Test.Check( status )
    << "Testing of root directory support"
    << std::endl
    ;
}

void
SubDirectory( )
{
  bool status = false;

  try
  {
    mount_points_type	m;
    m[ "/junk1" ] = NULL;
    m[ "/junk2" ] = NULL;
    m[ "/junk3" ] = NULL;

    mount_points_type::const_iterator i = m.Locate( "/junk2/stuff/under/dir" );

    status = ( ( i != m.end( ) )
	       && ( i->first.compare( "/junk2" ) == 0 ) );
  }
  catch( ... )
  {
    status = false;
  }
  Test.Check( status )
    << "Testing of subdirectory support"
    << std::endl
    ;
}

void
SubDirectory2( )
{
  bool status = false;

  try
  {
    mount_points_type	m;
    m[ "/junk1" ] = NULL;
    m[ "/junk2/stuff" ] = NULL;
    m[ "/junk2/su" ] = NULL;
    m[ "/junk3" ] = NULL;

    mount_points_type::const_iterator i = m.Locate( "/junk2/stuff/under/dir" );

    status = ( ( i != m.end( ) )
	       && ( i->first.compare( "/junk2/stuff" ) == 0 ) );
  }
  catch( ... )
  {
    status = false;
  }
  Test.Check( status )
    << "Testing of subdirectory support (2)"
    << std::endl
    ;
}

void
SubDirectory3( )
{
  bool status = false;

  try
  {
    mount_points_type	m;
    m[ "/junk1" ] = NULL;
    m[ "/junk2/stu" ] = NULL;
    m[ "/junk2/stuff" ] = NULL;
    m[ "/junk3" ] = NULL;

    mount_points_type::const_iterator i = m.Locate( "/junk2/stu/under/dir" );

    status = ( ( i != m.end( ) )
	       && ( i->first.compare( "/junk2/stu" ) == 0 ) );

    i = m.Locate( "/junk2/stuff/under/dir" );
    status = ( status
	       && ( i != m.end( ) )
	       && ( i->first.compare( "/junk2/stuff" ) == 0 ) );

  }
  catch( ... )
  {
    status = false;
  }
  Test.Check( status )
    << "Testing of subdirectory support (3)"
    << std::endl
    ;
}

int
main( int ArgC, char** ArgV )
{
  Test.Init(ArgC, ArgV);

  Unmanaged( );
  UnmanagedHead( );
  UnmanagedTail( );
  RootDirectory( );
  SubDirectory( );
  SubDirectory2( );
  SubDirectory3( );

  Test.Exit( );

  return 1;	// Should never get here so exit with error if it happens
}
