#ifndef ThreadDeclHH
#define ThreadDeclHH

class tid;

#if HAVE_TCL
#ifndef FOR_TCL
#define FOR_TCL 1
#endif /* FOR_TCL */
#endif

#if FOR_TCL
#include "tcl.h"
#endif /* FOR_TCL */

#define THRDDECL1( P1 ) P1 p1,
#define THRDDECL2( P1, P2 ) THRDDECL1( P1 ) P2 p2,
#define THRDDECL3( P1, P2, P3 ) THRDDECL2( P1, P2) P3 p3,
#define THRDDECL4( P1, P2, P3, P4 ) THRDDECL3( P1, P2, P3 ) P4 p4,
#define THRDDECL5( P1, P2, P3, P4, P5 ) THRDDECL4( P1, P2, P3, P4 ) P5 p5,
#define THRDDECL6( P1, P2, P3, P4, P5, P6 ) THRDDECL5( P1, P2, P3, P4, P5 ) P6 p6,
#define THRDDECL7( P1, P2, P3, P4, P5, P6, P7 ) THRDDECL6( P1, P2, P3, P4, P5, P6 ) P7 p7,
#define THRDDECL8( P1, P2, P3, P4, P5, P6, P7, P8 ) THRDDECL7( P1, P2, P3, P4, P5, P6, P7) P8 p8,
#define THRDDECL9( P1, P2, P3, P4, P5, P6, P7, P8, P9 ) THRDDECL8( P1, P2, P3, P4, P5, P6, P7, P8) P9 p9,
#define THRDDECL10( P1, P2, P3, P4, P5, P6, P7, P8, P9, P10 ) \
  THRDDECL9( P1, P2, P3, P4, P5, P6, P7, P8, P9) P10 p10,

#if FOR_TCL
#define CREATE_THREADED_BASE_DECL( F, R, Parms ) \
tid* F##_t( Parms Tcl_Interp* interp, const char* flag ); \
R F##_r( tid* t )
#define CREATE_THREADED_NO_PARAMS_BASE_DECL( F, R ) \
tid* F##_t( Tcl_Interp* interp, const char* flag ); \
R F##_r( tid* t )
#else /* FOR_<LANGUAGE> - unsupported language */
#define CREATE_THREADED_BASE_DECL( F, R, Parms ) \
void dummy_function_thread_decl( )
#define CREATE_THREADED_NO_PARAMS_BASE_DECL( F, R ) \
void dummy_function_thread_decl( )
#endif /* FOR_<LANGUAGE> */

#define CREATE_THREADED0_DECL( F, R ) \
CREATE_THREADED_NO_PARAMS_BASE_DECL( F, R )

#define CREATE_THREADED1_DECL( F, R, P1 ) \
CREATE_THREADED_BASE_DECL( F, R, THRDDECL1( P1 ) )

#define CREATE_THREADED2_DECL( F, R, P1, P2 ) \
CREATE_THREADED_BASE_DECL( F, R, THRDDECL2( P1, P2 ) )

#define CREATE_THREADED3_DECL( F, R, P1, P2, P3 ) \
CREATE_THREADED_BASE_DECL( F, R, THRDDECL3( P1, P2, P3 ) )

#define CREATE_THREADED4_DECL( F, R, P1, P2, P3, P4 ) \
CREATE_THREADED_BASE_DECL( F, R, THRDDECL4( P1, P2, P3, P4 ) )

#define CREATE_THREADED5_DECL( F, R, P1, P2, P3, P4, P5 ) \
CREATE_THREADED_BASE_DECL( F, R, THRDDECL5( P1, P2, P3, P4, P5 ) )

#define CREATE_THREADED6_DECL( F, R, P1, P2, P3, P4, P5, P6 ) \
CREATE_THREADED_BASE_DECL( F, R, THRDDECL6( P1, P2, P3, P4, P5, P6 ) )

#define CREATE_THREADED7_DECL( F, R, P1, P2, P3, P4, P5, P6, P7 ) \
CREATE_THREADED_BASE_DECL( F, R, THRDDECL7( P1, P2, P3, P4, P5, P6, P7 ) )

#define CREATE_THREADED8_DECL( F, R, P1, P2, P3, P4, P5, P6, P7, P8 ) \
CREATE_THREADED_BASE_DECL( F, R, THRDDECL8( P1, P2, P3, P4, P5, P6, P7, P8 ) )

#define CREATE_THREADED9_DECL( F, R, P1, P2, P3, P4, P5, P6, P7, P8, P9 ) \
CREATE_THREADED_BASE_DECL( F, R, THRDDECL9( P1, P2, P3, P4, P5, P6, P7, P8, P9 ) )

#define CREATE_THREADED10_DECL( F, R, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10 ) \
CREATE_THREADED_BASE_DECL( F, R, THRDDECL10( P1, P2, P3, P4, P5, P6, P7, P8, P9, P10 ) )

#define CREATE_THREADED0V_DECL( F ) \
CREATE_THREADED_NO_PARAMS_BASE_DECL( F, void )

#define CREATE_THREADED1V_DECL( F, P1 ) \
CREATE_THREADED_BASE_DECL( F, void, THRDDECL1( P1 ) )

#define CREATE_THREADED2V_DECL( F, P1, P2 ) \
CREATE_THREADED_BASE_DECL( F, void, THRDDECL2( P1, P2 ) )

#define CREATE_THREADED3V_DECL( F, P1, P2, P3 ) \
CREATE_THREADED_BASE_DECL( F, void, THRDDECL3( P1, P2, P3 ) )

#define CREATE_THREADED4V_DECL( F, P1, P2, P3, P4 ) \
CREATE_THREADED_BASE_DECL( F, void, THRDDECL4( P1, P2, P3, P4 ) )

#define CREATE_THREADED5V_DECL( F, P1, P2, P3, P4, P5 ) \
CREATE_THREADED_BASE_DECL( F, void, THRDDECL5( P1, P2, P3, P4, P5 ) )

#define CREATE_THREADED6V_DECL( F, P1, P2, P3, P4, P5, P6 ) \
CREATE_THREADED_BASE_DECL( F, void, THRDDECL6( P1, P2, P3, P4, P5, P6 ) )

#define CREATE_THREADED7V_DECL( F, P1, P2, P3, P4, P5, P6, P7 ) \
CREATE_THREADED_BASE_DECL( F, void, THRDDECL7( P1, P2, P3, P4, P5, P6, P7 ) )

#define CREATE_THREADED8V_DECL( F, P1, P2, P3, P4, P5, P6, P7, P8 ) \
CREATE_THREADED_BASE_DECL( F, void, THRDDECL8( P1P2, P3, P4, P5, P6, P7, P8 ) )

#define CREATE_THREADED9V_DECL( F, P1, P2, P3, P4, P5, P6, P7, P8, P9 ) \
CREATE_THREADED_BASE_DECL( F, void, THRDDECL9( P1P2, P3, P4, P5, P6, P7, P8, P9 ) )

#define CREATE_THREADED10V_DECL( F, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10 ) \
CREATE_THREADED_BASE_DECL( F, void, THRDDECL10( P1P2, P3, P4, P5, P6, P7, P8, P9, P10 ) )

#endif // ThreadDeclHH
