#include "genericAPI/config.h"

#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <iostream>

#include "genericAPI/FileLock.hh"

GenericAPI::FileLock::
FileLock( const std::string& Filename )
  : m_filename( Filename )
{
  m_fd = open( Filename.c_str( ),
	       O_WRONLY | O_CREAT | O_APPEND,
	       S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH );
}

GenericAPI::FileLock::
~FileLock( )
{
  if ( m_buffer.str( ).length( ) > 0 )
  {
    lockf( m_fd, F_LOCK , 0 );
    lseek( m_fd, 0, SEEK_END );
    size_t	bytes
      = ::write( m_fd, m_buffer.str( ).c_str( ), m_buffer.str( ).length( ) );
    if ( bytes != m_buffer.str( ).length( ) )
    {
      std::cerr << "WARNING: GenericAPI::FileLock::~FileLock wrote "
		<< bytes << " bytes instead of " << m_buffer.str( ).length( )
		<< " bytes.\n"
	;
    }
  }
  lseek( m_fd, 0, SEEK_SET );	// Go to the beginning
  lockf( m_fd, F_ULOCK, 0 );	// Release all locks
  close( m_fd );
}

