#ifndef RDS_UTIL_HH
#define RDS_UTIL_HH

   
#include <vector>
#include <string>   

#include "framecpp/Time.hh"
  
   
class Regex;
   
   
//-----------------------------------------------------------------
//   
//: List parser class.
//   
// Handles comma separated string list.
//   
class ListParser
{
public:

  ListParser( const char* list ); 
   
  ~ListParser(); 
   
  bool getNextToken();
  const std::vector< std::string > getTokenList();
   
private:

   static const char mSeparator;   
   static const char mOpen;
   static const char mClose;         
   
   char* mBuffer;
   const char* mStart;
   const char* mCurrPos;
   std::string mName;
};

   
class FrameName   
{
public:
   
   FrameName( const FrameCPP::Time& start, const REAL_8 dt )
      : mSec( start.getSec() ), mNan( start.getNSec() ), mDt( dt )
   {}
   const std::string operator()( const std::string& original_name,
      const std::string& dir ) const;

private:
   
   const std::string createName( const std::string& name ) const;

   static const Regex re_name;
   static const Regex re_rds_name;   
   
   const INT_4S mSec;
   const INT_4S mNan;   
   const REAL_8 mDt;   
};
   
   
#endif   
