#ifndef FRAME_API__CREATE_RDS_HH
#define FRAME_API__CREATE_RDS_HH

#include "general/types.hh"
#if !defined( SWIGIMPORTED )
#include "frameAPI/rdsframe.hh"
#include "frameAPI/rdsresample.hh"
#include "frameAPI/Frame.hh"
#endif /* !defined( SWIGIMPORTED ) */

#define CREATERDS_START_TYPE INT_4U
#define CREATERDS_END_TYPE INT_4U

#if !defined( SWIGIMPORTED )
namespace FrameAPI
{
  typedef ::RDSFrame::frame_file_container_type frame_file_container_type;
  typedef struct {
    typedef ::RDSFrame::channel_container_type channel_type;
    typedef ::ResampleRawFrame::resample_container_type resampling_type;

    channel_type	names;
    resampling_type	resampling;
  } channel_container_type;

  typedef CREATERDS_START_TYPE start_type;
  typedef CREATERDS_END_TYPE end_type;
  typedef RDS::Options::compression_level_type compression_level_type;
  typedef RDS::Options::compression_method_type compression_method_type;
  typedef RDS::Options::frames_per_file_type frames_per_file_type;
  typedef RDS::Options::seconds_per_frame_type seconds_per_frame_type;

  Frame
  createRDSFrame( const frame_file_container_type& FrameFiles,
		  start_type Start,
		  end_type End,
		  const channel_container_type& Channels );
  
  void
  createRDSSet(	const frame_file_container_type& FrameFiles,
		const channel_container_type& Channels,
		const FrameAPI::RDS::FileOptions& Opts );
}
#endif /* !defined( SWIGIMPORTED ) */

#endif /* FRAME_API__CREATE_RDS_HH */
