#ifndef FRAME_API__STAGE__HH
#define FRAME_API__STAGE__HH

#include "config.h"

#include <string>

#include "DeviceIOConfiguration.hh"
#include "SAMFSLoader.hh"

namespace FrameAPI
{
  static SAMFSLoader	samfs;
  
  inline void
  Stage( const std::string& Filename )
  {
    DeviceIOConfiguration::size_type	size;
    bool				memory_mapped_io;
    std::string				fstype;
      
    DeviceIOConfiguration::GetConfiguration( Filename.c_str( ),
					     size,
					     memory_mapped_io,
					     fstype );
    if ( fstype == "samfs" )
    {
      //---------------------------------------------------------------
      // Stage for immediate loading
      //---------------------------------------------------------------
      samfs.Stage( Filename, "i" );
    }
  } // function Stage

} // namespace - FrameAPI

#endif /* FRAME_API__STAGE__HH */
