/* -*- mode: c++ -*- */
/** \cond IGNORE_BY_DOXYGEN */
%define DOCSTRING
"The LDASframe package for Python allows for Python
developers to interface with the frameAPI library create by the LDAS team."
"The specification on which this interface is based can be found at:"
"https://dcc.ligo.org/cgi-bin/private/DocDB/ShowDocument?docid=329"
%enddef

%module(docstring=DOCSTRING) LDASframe
%feature("autodoc","1");

%{
#include "Channel.hh"

using namespace FrameAPI;
%}

%include "std_string.i"
%include "std_vector.i"

typedef std::vector< std::string > swig_vector_string_type;

%include "LDASframePython.i"

%include "general/SharedPtr.i"
%include "general/SharedArray.i"

%SharedPtr(Channel)
%SharedPtr(ChannelDict)
%SharedPtr(DataDictionary)
%SharedPtr(Frame)

 // %import "frameCPP/FrAdcData.i"
 // %import "frameCPP/FrProcData.i"
 //  %import "framecpp/FrVect.i"

%include "Channel.i"
%include "Frame.i"
%include "Catalog.i"
%include "createRDS.i"
