#if HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <list>
#include <string>

#include "general/types.hh"

#include "Binary.hh"

typedef INT_4U swap_type;

static const std::string TAG( "<DiSKCaCHeVerSIONed>" );
static const std::string TAG_OLD( "<DiSKCaCHe>" );
static const swap_type SWAP_REFERENCE = 0x12345678;

namespace diskCache
{
  namespace Streams
  {
    //===================================================================
    // IBinary
    //===================================================================
    IBinary::reader_container_type IBinary::m_readers;

    IBinary::
    IBinary( std::istream& Source )
      : IInterface( Source ),
	m_swap( false )
    {
      //-----------------------------------------------------------------
      // Setup to throw an exception once the end of file is reached.
      //-----------------------------------------------------------------
      m_stream.exceptions( m_stream.exceptions( )
			   | std::istream::eofbit );
      //-----------------------------------------------------------------
      // Determine the version of the frame file
      //-----------------------------------------------------------------
      char buffer[ 256 ];
      m_stream.read( buffer, TAG_OLD.size( ) );
      buffer[ TAG_OLD.size( ) ] = '\0';
      //-----------------------------------------------------------------
      // Check to see if the buffer is of the old type
      //-----------------------------------------------------------------
      if ( TAG_OLD.compare( 0, TAG_OLD.size( ),
			    buffer, TAG_OLD.size( ) ) == 0 )
      {
	version( VERSION_NONE );
	return;
      }
      //-----------------------------------------------------------------
      // Read a few more bytes to check for newer version
      //-----------------------------------------------------------------
      m_stream.read( &buffer[ TAG_OLD.size( ) ],
		     TAG.size( ) - TAG_OLD.size( ) );
      buffer[ TAG.size( ) ] = '\0';
      if ( TAG.compare( 0, TAG.size( ), buffer, TAG.size( ) ) != 0 )
      {
	throw BadStream( );
      }
      //-----------------------------------------------------------------
      // Newer stream format with header information
      //-----------------------------------------------------------------
      swap_type		swap;
      version_type	v;

      m_stream.read( reinterpret_cast< char* >( &swap ), sizeof( swap ) );
      if ( swap != SWAP_REFERENCE )
      {
	reverse< sizeof( swap ) >( &swap, 1 );
	if ( swap != SWAP_REFERENCE )
	{
	  throw SwapError( );
	}
	m_swap = true;
      }
      //-----------------------------------------------------------------
      // Read the stream version number
      //-----------------------------------------------------------------
      v = 0;
      *this >> v;
      version( v );

    }

    IBinary::
    ~IBinary( )
    {
    }

    //===================================================================
    // OBinary
    //===================================================================
    OBinary::writer_container_type OBinary::m_writers;

    OBinary::
    OBinary( std::ostream& Sink, version_type Version )
      : OInterface( Version ),
	m_stream( Sink )
    {
      //-----------------------------------------------------------------
      // Put the header into the file
      //-----------------------------------------------------------------
      if ( Version < VERSION_HEADER )
      {
	//---------------------------------------------------------------
	// Tag
	//---------------------------------------------------------------
	m_stream.write( TAG_OLD.c_str( ), TAG_OLD.size( ) );
      }
      else
      {
	//---------------------------------------------------------------
	// Tag
	//---------------------------------------------------------------
	m_stream.write( TAG.c_str( ), TAG.size( ) );
	//---------------------------------------------------------------
	// Basic header
	//---------------------------------------------------------------
	*this << SWAP_REFERENCE	// Label the endianness
	      << Version	// Record the version number
	  ;
      }
      
    } // OBinary::OBinary

    OBinary::
    ~OBinary( )
    {
    }

    // template OBinary& OBinary::operator<< <std::string,std::list>( const std::list< std::string >& Data );
  } // namespace - Streams
} // namespace - diskCache
