#ifndef DISKCACHE_API__SCAN_MOUNT_POINTS_DAEMON_HH
#define DISKCACHE_API__SCAN_MOUNT_POINTS_DAEMON_HH

#include "config.h"

#include "general/mutexlock.hh"
#include "general/Task.hh"
#include "general/types.hh"

namespace diskCache
{
  //====================================================================================
  /// \brief Continuous scanning of the mount point lists
  //====================================================================================
  class ScanMountPointsDaemon
    : public General::Task
  {
  public:
    typedef INT_4U interval_type;

    ScanMountPointsDaemon( std::ostream* Stream );

    static interval_type Interval( );

    static void Interval( interval_type Value );

    virtual void operator()( );

  private:
    //-----------------------------------------------------------
    /// \brief Syncronize variable access
    //-----------------------------------------------------------
    static MutexLock::lock_type m_variable_baton;

    //-----------------------------------------------------------
    /// \brief Delay between scans
    //-----------------------------------------------------------
    static interval_type	m_interval;

#if 0
    std::ostream*     		m_stream;
#endif /* 0 */
  };

  inline ScanMountPointsDaemon::interval_type ScanMountPointsDaemon::
  Interval( )
  {
    MutexLock  l( m_variable_baton );

    return m_interval;
  }

  inline void ScanMountPointsDaemon::
  Interval( interval_type Value )
  {
    MutexLock  l( m_variable_baton );

    m_interval = Value;
  }

}
#endif /* DISKCACHE_API__SCAN_MOUNT_POINTS_DAEMON_HH */
