#include "config.h"

#include "general/AtExit.hh"
#include "general/Thread.hh"

#include "diskcachecmd.hh"
#include "MountPointScanner.hh"
#include "ScanMountPointsDaemon.hh"

using General::Thread;

namespace diskCache
{
  MutexLock::lock_type ScanMountPointsDaemon::m_variable_baton
  = MutexLock::Initialize( );

  //-----------------------------------------------------------------------------
  /// This variable specifies the number of milliseconds to delay between
  /// successive scans of the list of mount points.
  ///
  /// The default value is 500 ( 0.5 sec. ).
  //-----------------------------------------------------------------------------
  ScanMountPointsDaemon::interval_type	ScanMountPointsDaemon::m_interval = 500;

  ScanMountPointsDaemon::
  ScanMountPointsDaemon( std::ostream* Stream )
#if 0
    : m_stream( Stream )
#endif /* 0 */
  {
    delete_on_completion( true );
  }

  void ScanMountPointsDaemon::
  operator()( )
  {
    //---------------------------------------------------------------------------------
    // Scan as long as the application is running.
    //---------------------------------------------------------------------------------
    while( General::AtExit::IsExiting( ) == false )
    {
      //------------------------------------------------------------------------------
      // Scan through the list of mount points.
      //------------------------------------------------------------------------------
      if ( MountPointScanner::SyncRequest::PendingRequests( ) == 0 )
      {
	MountPointScanner::ScanResults	results;
	ScanMountPointList( results );

	/// \todo
	///     Need to format the results of scanning and then dump out either
	///     to the requested stream or use the logging mechanism.
#if WORKING
	if ( Stream )
	{
	}
	else
	{
	}
#endif /* WORKING */
      }
      //-----------------------------------------------------------------
      /// Suspend scanning for a period of time
      //-----------------------------------------------------------------
      struct timespec wakeup;
      const interval_type	i( Interval( ) );
      wakeup.tv_sec = i / 1000;
      wakeup.tv_nsec = ( i % 1000 ) * 1000000;
      //-----------------------------------------------------------------
      // Modify the cancellation signal to be a true signal to allow
      // interuptability
      //-----------------------------------------------------------------
      int old_aux = 0;
      const Thread::cancel_type
	old_type( Thread::Self::CancellationType( old_aux ) );
      Thread::Self::CancellationType( Thread::CANCEL_BY_SIGNAL, SIGTERM );
      nanosleep( &wakeup, NULL );
      Thread::Self::CancellationType( old_type, old_aux );
    }
  }
}
