#include <unistd.h>

#include <sstream>

#include "ldastoolsal/unittest.h"

LDASTools::Testing::UnitTest Test;

void
test_helper( const char* TestDir,
	     const char** Files,
	     const int FileCount,
	     bool Expected )
{
  if ( access( TestDir, X_OK ) != 0 )
  {
    /* Skip the test */
    return;
  }

  const char** cur_file;
  const char** last_file;

  for ( cur_file = Files,
        last_file = &(Files[ FileCount ]);
	cur_file != last_file;
	++cur_file )
  {
    {
      std::ostringstream	cmd_base;
      std::ostringstream	cmd;

      cmd_base << "./framecpp_checksum"
	       << " --checksum-frame"
	       << " --checksum-file"
	       << " --checksum-structure"
	       << " " << TestDir << "/" << *cur_file
	;
      cmd << cmd_base.str( )
	  << " > /dev/null 2>&1"
	  << " < /dev/null"
	;
      
      int ret = system( cmd.str( ).c_str( ) );
      Test.Check( ( ret == 0 ) == Expected )
	<< ": file: " << TestDir << "/" << *cur_file
	<< " ret: " << ret
	<< " cmd: " << cmd_base.str( )
	<< std::endl
	;
    }
    {
      std::ostringstream	cmd_base;
      std::ostringstream	cmd;

      cmd_base << "./framecpp_verify"
	       << " --verbose"
	       << " " << TestDir << "/" << *cur_file
	;
      cmd << cmd_base.str( )
	  << " > /dev/null 2>&1"
	  << " < /dev/null"
	;
      
      int ret = system( cmd.str( ).c_str( ) );
      Test.Check( ( ret == 0 ) == Expected )
	<< ": file: " << TestDir << "/" << *cur_file
	<< " ret: " << ret
	<< " cmd: " << cmd_base.str( )
	<< std::endl
	;
    }
  }
}

void
test_bad_crc( )
{
  const char* files[] =
    { "L-R-991431920-16.gwf.bad",
      "L-R-991432112-16.gwf.bad",
      "L-R-991434112-16.gwf.bad"
    };
  test_helper( "/devscratch/test/frames/bad",
	       files, sizeof( files ) / sizeof( *files ),
	       false );
}

void
test_S6( )
{
  const char* files[] =
    { "H-R-971621600-32.gwf",
      "H-R-971621632-32.gwf",
      "H-R-971621664-32.gwf",
      "H-R-971621696-32.gwf"
    };
  test_helper( "/devscratch/frames/Samples/S6/L0/LHO/H-R-9716",
	       files, sizeof( files ) / sizeof( *files ),
	       true );
}

int
main( int ArgC, char* ArgV[] )
try
{
  //---------------------------------------------------------------------
  // Setup
  //---------------------------------------------------------------------
  
  Test.Init( ArgC, ArgV );


  //---------------------------------------------------------------------
  // 
  //---------------------------------------------------------------------
  test_bad_crc( );
  test_S6( );
  
  //---------------------------------------------------------------------
  // Exit
  //---------------------------------------------------------------------
  Test.Exit();
}
catch ( ... )
{
  //---------------------------------------------------------------------
  // Setup
  //---------------------------------------------------------------------
  
  Test.Check( false ) << "Caught an exception" << std::endl;

  //---------------------------------------------------------------------
  // Exit
  //---------------------------------------------------------------------
  Test.Exit( );
}
