#include <framecpp_config.h>

#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/Description.hh"

#include "framecpp/Version4/FrSummary.hh"
#include "framecpp/Version4/FrSE.hh"
#include "framecpp/Version4/FrSH.hh"
#include "framecpp/Version4/PTR_STRUCT.hh"

#include "Common/ComparePrivate.hh"

using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;

//=======================================================================
// Static
//=======================================================================

static const FrameSpec::Info::frame_object_types s_object_id
= FrameSpec::Info::FSI_FR_SUMMARY;

static const int MAX_REF = 2;

namespace FrameCPP
{
  namespace Version_4
  {
    //=======================================================================
    // FrSummary::fr_summary_data_type
    //=======================================================================

    bool FrSummary::fr_summary_data_type::
    operator==( const fr_summary_data_type& RHS ) const
    {
#define CMP__(X) ( X == RHS.X )

      return ( ( &RHS == this )
	       || ( CMP__( name )
		    && CMP__( comment )
		    && CMP__( test )
		    && CMP__( moments )
		    && CMP__( table )
		    ) )
	;
#undef CMP__
    }

    //=======================================================================
    // FrSummary
    //=======================================================================
    FrSummary::
    FrSummary( )
      : FrameSpec::Object( s_object_id, StructDescription( ) )
    {
    }

    FrSummary::
    FrSummary( const FrSummary& Summary )
      : FrameSpec::Object( s_object_id, StructDescription( ) ),
	Common::TOCInfo( Summary )
    {
      m_data.name = Summary.m_data.name;
      m_data.comment = Summary.m_data.comment;
      m_data.test = Summary.m_data.test;
      m_data.moments = Summary.m_data.moments;
      m_data.table = Summary.m_data.table;
    }

    FrSummary::
    FrSummary( const std::string& name,
	       const std::string& comment,
	       const std::string& test )
      : FrameSpec::Object( s_object_id, StructDescription( ) )
    {
      m_data.name = name;
      m_data.comment = comment;
      m_data.test = test;
    }

    FrSummary::
    FrSummary( Previous::FrSummary& Source, istream_type* Stream )
      : FrameSpec::Object( s_object_id, StructDescription( ) )
    {
      m_data.name = Source.GetName( );
      m_data.comment = Source.GetComment( );
      m_data.test = Source.GetTest( );

      if ( Stream )
      {
	//-------------------------------------------------------------------
	// Modify references
	//-------------------------------------------------------------------
	Stream->ReplaceRef( RefMoments( ), Source.RefMoments( ), MAX_REF );
      }
    }

    FrSummary::
    FrSummary( istream_type& Stream )
      : FrameSpec::Object( s_object_id, StructDescription( ) )
    {
      Stream >> m_data.name
	     >> m_data.comment
	     >> m_data.test
	     >> m_data.moments
	     >> m_data.table
	;
      Stream.Next( this );
    }

    FrameCPP::cmn_streamsize_type FrSummary::
    Bytes( const Common::StreamBase& Stream ) const
    {
      return
	m_data.name.Bytes( )
	+ m_data.comment.Bytes( )
	+ m_data.test.Bytes( )
	+ Stream.PtrStructBytes( )	// moments
	+ Stream.PtrStructBytes( )	// table
	+ Stream.PtrStructBytes( )	// next
	;
    }

    const std::string& FrSummary::GetName( ) const
    {
      return m_data.name;
    }


    FrSummary* FrSummary::
    Create( istream_type& Stream ) const
    {
      return new FrSummary( Stream );
    }

    const char* FrSummary::
    ObjectStructName( ) const
    {
      return StructName( );
    }

    const Description* FrSummary::
    StructDescription( )
    {
      static Description ret;

      if ( ret.size( ) == 0 )
      {
	ret( FrSH( FrSummary::StructName(), s_object_id,
		   "Summary Data Structure" ) );

	ret( FrSE( "name", "STRING" ) );
	ret( FrSE( "comment", "STRING" ) );
	ret( FrSE( "test", "STRING" ) );

	ret( FrSE( "moments", PTR_STRUCT::Desc( FrVect::StructName( ) ) ) );
	ret( FrSE( "table", PTR_STRUCT::Desc( FrTable::StructName( ) ) ) );

	ret( FrSE( "next", PTR_STRUCT::Desc( FrSummary::StructName( ) ) ) );
      }

      return &ret;
    }

    void FrSummary::
    Write( ostream_type& Stream ) const
    {
      Stream << m_data.name
	     << m_data.comment
	     << m_data.test
	     << m_data.moments
	     << m_data.table
	;
      WriteNext( Stream );
    }

    FrSummary& FrSummary::
    Merge( const FrSummary& RHS )
    {
      //:TODO: Need to implement Merge routine
      std::string msg( "Merge currently not implemented for " );
      msg += StructName( );

      throw std::domain_error( msg );
      return *this;
    }

    void FrSummary::
#if WORKING_VIRTUAL_TOCQUERY
    TOCQuery( int InfoClass, ... ) const
#else /*  WORKING_VIRTUAL_TOCQUERY */
    vTOCQuery( int InfoClass, va_list vl ) const
#endif /*  WORKING_VIRTUAL_TOCQUERY */
    {
      using Common::TOCInfo;

#if WORKING_VIRTUAL_TOCQUERY
      va_list	vl;
      va_start( vl, InfoClass );
#endif /*  WORKING_VIRTUAL_TOCQUERY */

      while ( InfoClass != TOCInfo::IC_EOQ )
      {
	int data_type = va_arg( vl, int );
	switch( data_type )
	{
	case TOCInfo::DT_STRING_2:
	  {
	    STRING* data = va_arg( vl, STRING* );
	    switch( InfoClass )
	    {
	    case TOCInfo::IC_NAME:
	      *data = GetName( );
	      break;
	    default:
	      goto cleanup;
	      break;
	    }
	  }
	  break;
	default:
	  // Stop processing
	  goto cleanup;
	}
	InfoClass = va_arg( vl, int );
      }
    cleanup:
#if WORKING_VIRTUAL_TOCQUERY
      va_end( vl )
#endif /*  WORKING_VIRTUAL_TOCQUERY */
	;
    }

    bool FrSummary::
    operator==( const Common::FrameSpec::Object& Obj ) const
    {
      return Common::Compare( *this, Obj );
    }

    FrSummary::demote_ret_type FrSummary::
    demote( INT_2U Target,
	    demote_arg_type Obj,
	    istream_type* Stream ) const
    {
      if ( Target >= DATA_FORMAT_VERSION )
      {
	return Obj;
      }
      try
      {
	//-------------------------------------------------------------------
	// Copy non-reference information
	//-------------------------------------------------------------------
	// Do actual down conversion
	demote_ret_type
	  retval( new Previous::FrSummary( GetName( ),
					   GetComment( ),
					   GetTest( )
					   ) )
	  ;
	if ( Stream )
	{
	  //-----------------------------------------------------------------
	  // Modify references
	  //-----------------------------------------------------------------
#if WORKING
	  Stream->ReplaceRef( retval->RefMoments( ), RefMoments( ), MAX_REF );
	  Stream->RemoveResolver( &(RefTable( )), MAX_REF );
#else
	  assert( 0 );
#endif
	}
	//-------------------------------------------------------------------
	// Return demoted object
	//-------------------------------------------------------------------
	return retval;
      }
      catch( ... )
      {
      }
      throw
	Unimplemented( "Object* FrSummary::demote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }

    FrSummary::promote_ret_type FrSummary::
    promote( INT_2U Target,
	     promote_arg_type Obj,
	     istream_type* Stream ) const
    {
      return Promote( Target, Obj, Stream );
    }
  } // namespace - Version_4
} // namespace - FrameCPP
