#ifndef FrameCPP_VERSION_4_FrTOCSimData_HH
#define FrameCPP_VERSION_4_FrTOCSimData_HH

#include "framecpp/Common/FrTOC.hh"

#include "framecpp/Version4/FrTOCPosition.hh"
#include "framecpp/Version4/STRING.hh"

namespace FrameCPP
{
  namespace Common
  {
    class TOCInfo;
  }

  namespace Version_4
  {
    //===================================================================
    //===================================================================
    class FrTOCSimData
      : public FrTOCPosition
    {
    public:
      typedef FrTOCPosition::n_type		nsim_type;
      typedef FrTOCPosition::position_type	position_type;

      typedef FrTOCPosition::info_type	sim_info_type;
      typedef FrTOCPosition::Map_type	MapSim_type;

      FrTOCSimData( );

      static void Description( Common::Description& Desc );

      const MapSim_type& GetSim( ) const;

      MapSim_type::const_iterator GetSim( const std::string& Name ) const;

      MapSim_type::const_iterator GetSim( INT_4U index ) const;

      void QuerySim( const Common::TOCInfo& Info,
		     INT_4U FrameOffset,
		     INT_8U Position );

      bool operator==( const FrTOCSimData& RHS ) const;

    protected:
      FrTOCSimData( Common::IStream& Stream, INT_4U FrameCount );

      //-----------------------------------------------------------------
      /// \brief Iterate over contents.
      ///
      /// \param[in] Info
      ///     Specifies the type of information to be searched.
      ///
      /// \param[in] Action
      ///     Action to be taken for each piece of information found.
      //-----------------------------------------------------------------
      void forEach( Common::FrTOC::query_info_type Info,
		    Common::FrTOC::FunctionBase& Action ) const;

      void write( Common::OStream& Stream ) const;
    };

    inline FrTOCSimData::
    FrTOCSimData( )
    {
    }

    inline FrTOCSimData::
    FrTOCSimData( Common::IStream& Stream, INT_4U FrameCount )
      : FrTOCPosition( Stream, FrameCount )
    {
    }

    inline const FrTOCSimData::MapSim_type& FrTOCSimData::
    GetSim( ) const
    {
      return getInfo( );
    }

    inline FrTOCSimData::MapSim_type::const_iterator FrTOCSimData::
    GetSim( const std::string& Channel ) const
    {
      return getInfo( Channel );
    }

    inline FrTOCSimData::MapSim_type::const_iterator FrTOCSimData::
    GetSim( INT_4U Channel ) const
    {
      return getInfo( Channel );
    }

    inline void FrTOCSimData::
    write( Common::OStream& Stream ) const
    {
      FrTOCPosition::write( Stream );
    }
  } // namespace - Version_4
} // namespace - FrameCPP

#endif /* FrameCPP_VERSION_4_FrTOCSimData_HH */
