#! /usr/bin/env python
#------------------------------------------------------------------------
# Test the reading of different types of FrVects from frames
#------------------------------------------------------------------------
from __future__ import division

import frameCPP
import numpy as np

__author__ = "Edward Maros <ed.maros@ligo.org>"

class frame:
    #--------------------------------------------------------------------
    # Set of channels and their expected numpy data types
    #--------------------------------------------------------------------
    channel_set = ( [ 'Z0:RAMPED_COMPLEX_16_1', np.complex128 ],
                    [ 'Z0:RAMPED_COMPLEX_8_1', np.complex64 ],
                    [ 'Z0:RAMPED_INT_2S_1', np.int16 ],
                    [ 'Z0:RAMPED_INT_2U_1', np.uint16 ],
                    [ 'Z0:RAMPED_INT_4S_1', np.int32 ],
                    [ 'Z0:RAMPED_INT_4U_1', np.uint32 ],
                    [ 'Z0:RAMPED_INT_8S_1', np.int64 ],
                    [ 'Z0:RAMPED_INT_8U_1', np.uint64 ],
                    [ 'Z0:RAMPED_REAL_4_1', np.float32 ],
                    [ 'Z0:RAMPED_REAL_8_1', np.float64 ] )

    #--------------------------------------------------------------------
    # Constructor taking the name of the frame file
    #--------------------------------------------------------------------
    def __init__(self, FrameVersion):
        filename = ( 'Z-std_fr_vect_types_ver%d-700000000-1.gwf' ) % ( FrameVersion )
        self.fs = frameCPP.IFrameFStream( filename )

    #--------------------------------------------------------------------
    # Destructor to ensure things are properly cleaned
    #--------------------------------------------------------------------
    def __del__(self):
        self.fs = None

    #--------------------------------------------------------------------
    # Iterate over channels
    #--------------------------------------------------------------------
    def check(self):
        retval = True
        for c in ( self.channel_set ):
            retval = self.verifyChannelType( c[0], c[1] ) and retval
        return retval

    #--------------------------------------------------------------------
    # Read the channel and verify the data type of the numpy array
    #--------------------------------------------------------------------
    def verifyChannelType(self, ChannelName, ChannelType ):
        retval = True
        adc = self.fs.ReadFrAdcData(0, ChannelName)
        retval = ( adc.data[ 0 ].GetDataArray( ).dtype.type == ChannelType )
        return retval

if __name__ == "__main__":
    #--------------------------------------------------------------------
    # This is a simple script to verify that the C++ interface for
    #   Python generates the expected data type numpy arrays.
    #--------------------------------------------------------------------
    retval = True
    for x in ( 8, 7, 6 ):
        f = frame( x )
        retval = f.check( ) and retval
    if retval:
        exit( 0 )
    else:
        exit( 1 )
