#include <framecpp_config.h>

#include <memory>

#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/STRING.hh"
#include "framecpp/Common/FrameSpec.tcc"

#include "framecpp/Version8/FrameSpec.hh"

#include "framecpp/Version8/FrSH.hh"

#include "Common/ComparePrivate.hh"

using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::Description;
using FrameCPP::Common::IStream;
using FrameCPP::Common::OStream;

namespace FrameCPP
{
  namespace Version_8
  {
    FrSH::
    FrSH( )
    {
    }


    FrSH::
    FrSH( const std::string& Name, INT_2U ClassId, const std::string& Comment )
    {
      m_data.name = Name;
      m_data.classId = ClassId;
      m_data.comment = Comment;
    }

    FrSH::
    FrSH( Common::IStream& Stream )
    {
      Stream >> m_data.name
	     >> m_data.classId
	     >> m_data.comment
	;
    }

    FrSH::
    ~FrSH( )
    {
    }

    FrSH* FrSH::
    Clone( ) const
    {
      return new FrSH( *this );
    }

#if NEEDED
    FrameSpec::Object* FrSH::
    Demote( Object* Obj, IStream* Stream ) const
    {
      if ( dynamic_cast< FrSH* >( Obj ) != (FrSH*)NULL )
      {
	return Obj;
      }
      throw
	Unimplemented( "Object* FrSH::Demote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }

    FrameSpec::Object* FrSH::
    Promote( Object* Obj, IStream* Stream ) const
    {
      if ( dynamic_cast< FrSH* >( Obj ) != (FrSH*)NULL )
      {
	return Obj;
      }
      throw
	Unimplemented( "Object* FrSH::Promote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }
#endif /* NEEDED */

    const char* FrSH::
    ObjectStructName( ) const
    {
      return StructName( );
    }


    bool FrSH::
    operator==( const FrSH& RHS ) const
    {
      return ( ( m_data.name == RHS.m_data.name )
	       && ( m_data.classId == RHS.m_data.classId )
	       && ( m_data.comment == RHS.m_data.comment ) );
    }

    bool FrSH::
    operator==( const Common::FrameSpec::Object& Obj ) const
    {
      return Common::Compare( *this, Obj );
    }

    void FrSH::
#if WORKING_VIRTUAL_TOCQUERY
    TOCQuery( int InfoClass, ... ) const
#else /*  WORKING_VIRTUAL_TOCQUERY */
      vTOCQuery( int InfoClass, va_list vl ) const
#endif /*  WORKING_VIRTUAL_TOCQUERY */
    {
      using Common::TOCInfo;

#if WORKING_VIRTUAL_TOCQUERY
      va_list	vl;
      va_start( vl, InfoClass );
#endif /*  WORKING_VIRTUAL_TOCQUERY */

      while ( InfoClass != TOCInfo::IC_EOQ )
      {
	int data_type = va_arg( vl, int );
	switch( data_type )
	{
	case TOCInfo::DT_STRING_2:
	  {
	    Common::STRING< INT_2U >*
	      data = va_arg( vl, Common::STRING< INT_2U >* );
	    *data = GetName( );
	  }
	  break;
	case TOCInfo::DT_INT_2U:
	  {
	    INT_2U*	data = va_arg( vl, INT_2U* );
	    *data = GetClass( );
	  }
	  break;
	default:
	  // Stop processing
	  InfoClass = TOCInfo::IC_EOQ;
	  continue;
	}
	InfoClass = va_arg( vl, int );
      }
#if WORKING_VIRTUAL_TOCQUERY
      va_end( vl )
#endif /*  WORKING_VIRTUAL_TOCQUERY */
	;
    }

    void FrSH::
    assign( assign_stream_type& Stream )
    {
      Stream >> m_data.name
	     >> m_data.classId
	     >> m_data.comment
	;
    }

    INT_8U FrSH::
    pBytes( const Common::StreamBase& Stream ) const
    {
      return
	m_data.name.Bytes( ) +
	sizeof( m_data.classId ) +
	m_data.comment.Bytes( );
    }

    FrSH* FrSH::
    pCreate( Common::IStream& Stream ) const
    {
      return new FrSH( Stream );
    }

    void FrSH::
    pWrite( Common::OStream& Stream ) const
    {
      Stream
	<< m_data.name
	<< m_data.classId
	<< m_data.comment
	;
    }

    const std::string& FrSH::
    name( ) const
    {
      return GetName( );
    }

    INT_2U FrSH::
    classId( ) const
    {
      return GetClass( );
    }


    FrSH::demote_ret_type FrSH::
    demote( INT_2U Target,
	    demote_arg_type Obj,
	    Common::IStream* Stream ) const
    {
      throw
	Unimplemented( "Object* FrSH::demote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }

    FrSH::promote_ret_type FrSH::
    promote( INT_2U Target,
	     promote_arg_type Obj,
	     Common::IStream* Stream ) const
    {
      throw
	Unimplemented( "Object* FrSH::promote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }

  } // namespace - Version_8
} // namespace - FrameCPP
