#include <filters_config.h>

#include "ldastoolsal/unittest.h"

#include "Sinc.hh"

using namespace std;
using namespace LDASTools::Testing;

UnitTest Test;

int main(int ArgC, char** ArgV)
{
  Test.Init(ArgC, ArgV);

  if (Test.IsVerbose())
  {
    cout << "$Id: tSinc.cc,v 1.2 2005/11/15 18:35:19 emaros Exp $" 
         << std::endl << std::flush;
  }
  
  Test.Check(Filters::Sinc(0) == 1) << "Sinc(0) == 1" << endl;
  Test.Check(abs(Filters::Sinc(0.5) - 2/LDAS_PI) < 1.0e-12)
    << "Sinc(0.5) ~= 2/LDAS_PI;"
    << endl;

  Test.Check(abs(Filters::Sinc(1)) < 1.0e-12)
    << "Sinc(1) ~= 0"
    << endl;

  Test.Exit();
}
