# -*- mode: RPM-SPEC; indent-tabs-mode: nil -*-
%define _docdir %{_datadir}/doc/ldas-tools-%{version}

Summary: Filters library used by ldas-tools
Name: ldas-tools-filters
Version: 2.5.2
Release: 1%{?dist}
License: ?
URL: http://www.ligo.caltech.edu
Group: Application/Scientific
BuildRoot: %{buildroot}
Source0: http://software.ligo.org/lscsoft/source/ldas-tools-filters-%{version}.tar.gz
Requires: ldas-tools-al
Buildrequires: autoconf
Buildrequires: automake
Buildrequires: doxygen
Buildrequires: libtool
Buildrequires: pkgconfig
Buildrequires: ldas-tools-al-devel >= 2.4.99

%description
This provides the runtime libraries for the filters library.

%package devel
Group: Development/Scientific
Summary: LDAS tools libfilters toolkit development files
Requires: ldas-tools-al-devel
Requires: ldas-tools-filters
%description devel
This provides the develpement files the filters library.
%prep

%setup -q

%build

%configure --disable-warnings-as-errors --with-optimization=high --disable-tcl --enable-python --docdir=%{_docdir}
make V=1 %{?_smp_mflags}
make V=1 check

%install
rm -rf %{buildroot}
#--------------------------------------------------------------
# install lscsoft specific files
#--------------------------------------------------------------
make V=1 install DESTDIR=%{buildroot}
#--------------------------------------------------------------
# Removed unwanted libtool files
#--------------------------------------------------------------
find %{buildroot} -name \*.la -exec rm -f {} \;
rm -f %{buildroot}%{python_sitearch}/LDAStools/_*.a
rm -f %{buildroot}%{python_sitearch}/LDAStools/libdiskcacheAPI_python.a

%post
ldconfig
%postun
ldconfig

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%{_libdir}/libfilters*.so.*

%files devel
%defattr(-,root,root)
%{_includedir}/filters
%{_docdir}/filters
%{_libdir}/libfilters*.*a
%{_libdir}/libfilters*.so
%{_libdir}/pkgconfig/ldas-tools-filters.pc

%changelog
* Wed Mar 23 2016 Edward Maros <ed.maros@ligo.org> - 2.4.99.4-1
- Made build be verbose

* Fri Mar 11 2016 Edward Maros <ed.maros@ligo.org> - 2.4.99.1-1
- Corrections for RPM build

* Thu Mar 03 2016 Edward Maros <ed.maros@ligo.org> - 2.4.99.0-1
- Breakout into separate source package

* Tue Oct 11 2011 Edward Maros <ed.maros@ligo.org> - 1.19.13-1
- Initial build.
