// -*-Mode: C++;-*-
#if defined(SWIGPYTHON)
//-----------------------------------------------------------------------
// Convert a Python list or string to a set of directories
//-----------------------------------------------------------------------
%typemap(in) const directory_container_type&
{
  //---------------------------------------------------------------------
  // Verify the input is a list
  //---------------------------------------------------------------------
  if ( PyList_Check($input) )
  {
    $1 = new directory_container_type;

    for ( int i = 0,
	    nitems = PyList_Size( $input );
	  i < nitems;
	  ++i )
    {
      PyObject *o = PyList_GetItem($input,i);

      if ( PyString_Check( o ) )
      {
	$1->push_back( PyString_AsString( o ) );
      }
      else
      {
	PyErr_SetString( PyExc_TypeError, "list must contain strings" );
	delete $1;
	return NULL;
      }
    }
  }
  else if ( PyString_Check( $input ) )
  {
    $1 = new directory_container_type;

    $1->push_back( PyString_AsString( $input ) );
  }
  else
  {
    PyErr_SetString( PyExc_TypeError, "Not a list nor a string" );
    return NULL;
  }
}
%typemap(freearg) const directory_container_type&
{
  delete $1;
}
#endif /* defined(SWIGPYTHON) */
