#include <diskcache_config.h>

#include <iostream>

#include "diskcacheAPI/Common/Registry.hh"

namespace diskCache
{
  namespace Common
  {
    Registry::Info::
    ~Info( )
    {
    } // method - Registry::Registry::~Info

    Registry::
    Registry( )
      : m_max_id( KEY_NULL )
    {
    }

    Registry::id_type Registry::
    Register( const Info& Key )
    {
      id_type	retval( KEY_NULL );

      if ( m_name_info.find( Key.m_key_name ) !=
	   m_name_info.end( ) )
      {
	throw AlreadyRegisteredException( Key.m_key_name,
					  m_name_info.find( Key.m_key_name )->second );
      }
      //-----------------------------------------------------------------
      /// \todo Lock the registry because changes are going to happen
      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      // With things properly locked, make the changes
      //-----------------------------------------------------------------
      ++m_max_id;
      retval = m_max_id;
      m_name_info[ Key.m_key_name ] = retval;
      m_info[ retval ] = info_type( Key.Clone( ) );
      return retval;
    } // method - Registry::Register

  } // namespace - Common
} // namespace - diskCache
