#include <diskcache_config.h>

#include <sstream>

#include "genericAPI/Logging.hh"

#include "ExcludedPattern.hh"

SINGLETON_INSTANCE_DEFINITION( LDASTools::AL::SingletonHolder< diskCache::Cache::ExcludedPattern > )

namespace diskCache
{
  namespace Cache
  {
    ExcludedPattern::
    ExcludedPattern( )
    {
      pattern_container_type	t;

      t.push_back( ".*[.]tmp");

      update( t );
    } /* ExcludedDirectories::ExcludedDirectories */

    ExcludedPattern::
    ~ExcludedPattern( )
    {
    }

    const ExcludedPattern::pattern_container_type& ExcludedPattern::
    Get( )
    {
      return Instance( ).get( );
    }

    bool ExcludedPattern::
    IsExcluded( const value_type& Filename )
    {
      return Instance( ).is_excluded( Filename );
    }

    void ExcludedPattern::
    Update( const pattern_container_type& Patterns )
    {
      Instance( ).update( Patterns );
    }

    const ExcludedPattern::pattern_container_type& ExcludedPattern::
    get( ) const
    {
      return readable_pattern;
    }

    bool ExcludedPattern::
    is_excluded( const value_type& Directory ) const
    {
      RegexMatch	compare( 1 );

      //-----------------------------------------------------------------
      // If the pattern is found, then it should be excluded.
      //-----------------------------------------------------------------
      return compare.match( pattern,
			    Directory.c_str( ) );
    }

    void ExcludedPattern::
    update( const pattern_container_type& Patterns )
    {
      static const char* caller = "ExcludedPattern::update";
      //-----------------------------------------------------------------
      // Generate a new regular expression to quickly identify
      // directories that should be excluded
      //-----------------------------------------------------------------
      std::string		old_pattern( pattern.getRegex( ) );
      std::ostringstream	r;
      bool			sep = false;

      readable_pattern = Patterns;
      r << "^(";
      for ( pattern_container_type::const_iterator
	      cur = readable_pattern.begin( ),
	      last = readable_pattern.end( );
	    cur != last;
	    ++cur )
      {
	if ( sep )
	{
	  r << "|";
	}
	else
	{
	  sep = true;
	}
	r << *cur;
      }
      r << ")$";

      //-----------------------------------------------------------------
      // Save the new pattern
      //-----------------------------------------------------------------
      pattern = Regex( r.str( ) );
      QUEUE_LOG_MESSAGE( "Updating file name exclusion pattern from: "
			 << old_pattern
			 << " to: "
			 << pattern.getRegex( )
			 ,
			 MT_NOTE,
			 0,
			 caller,
			 "CXX" );

    } /* ExcludedDirectories::Update */

  } /* namespace - Cache */
} /* namespace - diskCache */
