/* -*- mode: c++; c-basic-offset: 2; -*- */

#ifndef LDASTOOLSAL__TIMEOUT_HH
#define LDASTOOLSAL__TIMEOUT_HH

#include <stdexcept>

#include <memory>

#include "ldastoolsal/ConditionalVariable.hh"
#include "ldastoolsal/SharedPtr.hh"
#include "ldastoolsal/Task.hh"

namespace LDASTools
{
  namespace AL
  {
    class Task;
    class SystemCallTask;

    class TimeoutException
      : public std::runtime_error
    {
    public:
      TimeoutException( const std::string& msg );
    };

    const int TIMEOUT_TIMED_OUT 	= 0x0001;
    const int TIMEOUT_COMPLETED 	= 0x0002;

    int Timeout( Task* CallerTask, int Seconds,
		 int& Status,
		 bool ThrowTimeoutException = true );

    template< typename T >
    int Timeout( SharedPtr< T > CallerTask, int Seconds,
		 int& Status,
		 bool ThrowTimeoutException = true )
    {
      return Timeout( CallerTask.get( ), Seconds, Status, ThrowTimeoutException );
    }
  } // namespace - AL
} // namespace - LDASTools
#endif /* LDASTOOLSAL__TIMEOUT_HH */
