/* -*- mode: c++; c-basic-offset: 2; -*- */

#include <ldastoolsal_config.h>

#include <time.h>

#include <iostream>
#include <sstream>

#include "ldastoolsal/TaskTimer.hh"

namespace
{
  std::string
  mk_name( int Seconds )
  {
    std::ostringstream	retval;

    retval << "Timer: Seconds: " << Seconds
      ;
    return retval.str( );
  }
}

namespace LDASTools
{
  namespace AL
  {
    //-------------------------------------------------------------------
    /// Initialize the instance of the class.
    //-------------------------------------------------------------------
    Timer::
    Timer( int Seconds, signal_type CancelSignal )
      : Task( mk_name( Seconds ),
	      Thread::CANCEL_BY_SIGNAL,
	      CancelSignal ),
	m_timeout( Seconds ),
	m_err( false )
    {
    }

    //-------------------------------------------------------------------
    /// Return true if the timer expired before being cancelled.
    //-------------------------------------------------------------------
    bool Timer::
    Error( ) const
    {
      MutexLock	l( Baton( ),
		   __FILE__, __LINE__ );

      return m_err;
    }

    //-------------------------------------------------------------------
    /// For the timer task, the action is to start an interuptable
    /// sleep timer for the requested maximum time period.
    /// m_err is set to true if the sleep timer completes without
    /// any error.
    //-------------------------------------------------------------------
    void Timer::
    operator()( )
    {
      struct timespec wakeup;

      {
	MutexLock	l( Baton( ),
			   __FILE__, __LINE__ );

	wakeup.tv_sec = m_timeout;
	wakeup.tv_nsec = 0;
      }

      int err = ( nanosleep( &wakeup, NULL ) != 0 );
      {
	MutexLock	l( Baton( ),
			   __FILE__, __LINE__ );

	m_err = err;
      }
    }
  } // namespace - AL
} // namespace - LDASTools
