/* -*- mode: c++; c-basic-offset: 2; indent-tabs-mode: nil; -*- */
#ifndef LDASTOOLSAL__INFIX_ITERATOR_HH
#define LDASTOOLSAL__INFIX_ITERATOR_HH

#include <ostream>
#include <iterator>

namespace LDASTools
{
  namespace AL
  {
    template <class T,
              class charT=char,
              class traits=std::char_traits<charT> >

    class infix_ostream_iterator
      : public std::iterator<std::output_iterator_tag,void,void,void,void>
    {
      std::basic_ostream<charT,traits> *os;
      charT const* delimiter;
      bool first_elem;
    public:
      typedef charT char_type;
      typedef traits traits_type;
      typedef std::basic_ostream<charT,traits> ostream_type;

      infix_ostream_iterator(ostream_type& s)
        : os(&s),delimiter(0), first_elem(true)
      {
      }

      infix_ostream_iterator(ostream_type& s, charT const *d)
        : os(&s),delimiter(d), first_elem(true)
      {
      }

      infix_ostream_iterator<T,charT,traits>& operator=(T const &item)
      {
        // Here's the only real change from ostream_iterator:
        // We don't print the delimiter the first time. After that, 
        // each invocation prints the delimiter *before* the item, not
        // after. As a result, we only get delimiters *between* items,
        // not after every one.
        if ( ( !first_elem )
             && ( delimiter != 0 ) )
        {
          *os << delimiter;
        }
        *os << item;
        first_elem = false;
        return *this;
      }

      infix_ostream_iterator<T,charT,traits> &operator*()
      {
        return *this;
      }

      infix_ostream_iterator<T,charT,traits> &operator++()
      {
        return *this;
      }

      infix_ostream_iterator<T,charT,traits> &operator++(int)
      {
        return *this;
      }
    }; // class - infix_ostream_iterator
  } // namespace - AL
} // namespace - LDASTools


#endif /* LDASTOOLSAL__INFIX_ITERATOR_HH */
