#include <unistd.h>
#include <signal.h>

#include "ldastoolsal/unittest.h"

#include "ldastoolsal/SignalHandler.hh"

using LDASTools::AL::SignalHandler;
typedef LDASTools::AL::SignalHandler::Callback Callback;
typedef LDASTools::AL::SignalHandler::signal_type signal_type;

LDASTools::Testing::UnitTest Test;

void
sig_self( signal_type Signal )
{
  kill( getpid( ), SignalHandler::OSSignal( Signal ) );
}

void TestCallback( )
{
  static const char* test_name = "TestCallback";

  class cb_
    : public Callback
  {
  public:
    cb_( )
      : value( 0 )
    {
    }

    virtual void SignalCallback( signal_type Signal )
    {
      ++value;
    }

    int	value;
  } cb;

  static const signal_type	sig = SignalHandler::SIGNAL_HANGUP;

  SignalHandler::Register( &cb, sig );
  sig_self( sig );
  Test.Check( cb.value == 1 )
    << test_name << ":"
    << " Callback has been activated"
    << " ( " << cb.value << " =?= 1 )"
    << std::endl
    ;
  SignalHandler::Unregister( &cb, sig );
}

void TestCallbackAbort( )
{
  static const char* test_name = "TestCallbackAbort";

  class cb_
    : public Callback
  {
  public:
    cb_( )
      : value( 0 )
    {
    }

    virtual void SignalCallback( signal_type Signal )
    {
      ++value;
    }

    int	value;
  } cb;

  static const signal_type	sig = SignalHandler::SIGNAL_ABORT;

  SignalHandler::Register( &cb, sig );
  sig_self( sig );
  Test.Check( cb.value == 1 )
    << test_name << ":"
    << " Callback has been activated"
    << " ( " << cb.value << " =?= 1 )"
    << std::endl
    ;
  SignalHandler::Unregister( &cb, sig );
}

int
main(int argc, char** argv)
{
    Test.Init(argc, argv);

    TestCallback( );
    TestCallbackAbort( );

    Test.Exit();

    return 0;
}

